/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.common.DWAdapterConfigUtils;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.gateway.service.permission.DWSecurityInterceptor;
import com.digiwin.http.client.DWConnectKeepAliveStrategy;
import com.digiwin.http.client.DWDefaultAPIResponseRetryStrategy;
import com.digiwin.http.client.DWDefaultHttpRequestRetryHandler;
import com.digiwin.http.client.DWHTTPHostAppIdMapper;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWHttpClientProperties;
import com.digiwin.http.client.DWHttpResponseInterceptor;
import com.digiwin.http.client.DWHttpRetryArithmeticSequenceBackoff;
import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.DWHttpRetryProperties;
import com.digiwin.http.client.DWHttpRetrySimpleBackoff;
import com.digiwin.http.client.condition.DWHttpRetryCondition;
import com.digiwin.http.client.condition.DWHttpRetryExMessageKeywordsCondition;
import com.digiwin.http.client.condition.DWHttpRetryResponseStatusesCondition;
import com.digiwin.http.client.config.DWDAPPlatformHttpRetryConfigProvider;
import com.digiwin.http.client.config.DWHttpAPIInfoProvider;
import com.digiwin.http.client.config.DWHttpRetryConfigProvider;
import com.digiwin.http.client.config.apollo.DWApolloHttpAPIInfoProvider;
import com.digiwin.http.client.spring.DWSpringPKVRuleHostAppIdMapMapper;
import com.digiwin.http.serializer.DWHttpRetryBackoffDeserializer;
import com.digiwin.http.serializer.DWHttpRetryConditionDeserializer;
import com.digiwin.loadbalance.client.httpclient.DWAttemptHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWDefaultHttpLoadbalanceRoute;
import com.digiwin.loadbalance.client.httpclient.DWHttpClientBuild;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapper;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapperFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration
@DependsOn(value={"httpClientConfigProvider", "httpClientRequestContextProvider", "httpClientResourceBundleProvider", "dw-json-config", "dw-spring-context-utils"})
@AutoConfigureOrder(value=-2147483648)
public class DWHttpClientAutoConfiguration {
    public static final String BEAN_NAME_DW_HTTPCLIENT_HOST_API_MAPPER = "dw-httpclient-host-api-mapper";
    public static final String BEAN_NAME_DW_HTTPCLIENT_RETRY_CONFIG_PROVIDER = "dw-httpclient-retry-config-provider";
    public static final String BEAN_NAME_DW_HTTPCLIENT_API_INFO_PROVIDER = "dw-httpclient-api-info-provider";
    public static final String BEAN_NAME_DW_HTTPCLIENT_RETRY_MANAGER = "dw-httpclient-retry-manager";
    public static final String BEAN_NAME_DW_HTTPCLIENT_RETRY_PROPERTIES = "dw-httpclient-retry-properties";
    public static final String BEAN_NAME_DW_HTTPCLIENT_RESPONSE_INTERCEPTOR = "dw-httpclient-response-interceptor";
    public static final String BEAN_NAME_DW_HTTPCLIENT_RESPONSE_RETRY_STRATEGY = "dw-httpclient-response-retry-strategy";
    public static final String BEAN_NAME_DW_HTTPCLIENT_REQUEST_RETRY_HANDLER = "dw-httpclient-request-retry-handler";

    @Bean(value={"dw-http-client-properties"})
    public DWHttpClientProperties getHttpClientProperties(Environment environment) {
        DWHttpClientProperties properties = new DWHttpClientProperties();
        String connPropertyPrefix = environment.getProperty("dap.http.client.config.prefix", "dw") + "HttpConnectionConfig";
        properties.setMaxTotal(Integer.parseInt(environment.getProperty(connPropertyPrefix + "MaxTotal", "20")));
        properties.setDefaultMaxPerRoute(Integer.parseInt(environment.getProperty(connPropertyPrefix + "DefaultMaxPerRoute", "10")));
        properties.setValidateAfterInactivity(Integer.parseInt(environment.getProperty(connPropertyPrefix + "ValidateAfterInactivity", "2000")));
        String requestPropertyPrefix = environment.getProperty("dap.http.client.config.prefix", "dw") + "HttpRequestConfig";
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty(requestPropertyPrefix + "ConnectionRequestTimeout", "-1")));
        properties.setConnectTimeout(Integer.parseInt(environment.getProperty(requestPropertyPrefix + "ConnectTimeout", "-1")));
        properties.setSocketTimeout(Integer.parseInt(environment.getProperty(requestPropertyPrefix + "SocketTimeout", "-1")));
        String appId = environment.getProperty("appId");
        properties.setAppId(appId);
        properties.setIamUrl(environment.getProperty("iamUrl"));
        properties.setIamApToken(environment.getProperty("iamApToken", ""));
        properties.setTokenMode(environment.getProperty("serverHttpTokenmode", "IAM"));
        String keepAliveTimeoutString = environment.getProperty("dwHttpKeepAliveTimeout");
        if (keepAliveTimeoutString != null) {
            DWConnectKeepAliveStrategy connectionKeepAliveStrategy = new DWConnectKeepAliveStrategy();
            connectionKeepAliveStrategy.setKeepAliveTimeout((long)Integer.parseInt(keepAliveTimeoutString));
            properties.setConnectionKeepAliveStrategy((ConnectionKeepAliveStrategy)connectionKeepAliveStrategy);
        }
        String evictExpiredConnectionsString = environment.getProperty("dwHttpEvictExpiredConnections");
        properties.setEvictExpiredConnections(Boolean.parseBoolean(evictExpiredConnectionsString));
        String evictIdleConnectionsMaxIdleTimeString = environment.getProperty("dwHttpEvictIdleConnectionsMaxIdleTime");
        if (evictIdleConnectionsMaxIdleTimeString != null) {
            properties.setEvictIdleConnectionsMaxIdleTime(Long.valueOf(Long.parseLong(evictIdleConnectionsMaxIdleTimeString)));
        }
        properties.setIamApSecret(environment.getProperty("iamApSecret", ""));
        String globalEnabledString = environment.getProperty("dap.app-auth.auto-attach.enabled");
        String httpEnabledString = environment.getProperty("dap.app-auth.auto-attach.http.enabled");
        String mergedEnabledString = httpEnabledString == null ? globalEnabledString : httpEnabledString;
        properties.getAttachAppAuthInfoProperties().setEnabled(Boolean.parseBoolean(mergedEnabledString));
        Set includeAppIdSet = Collections.emptySet();
        String excludeAppIds = environment.getProperty("dap.app-auth.auto-attach.http.exclude", "");
        if (excludeAppIds.length() > 0) {
            List<String> tempList = Arrays.asList(excludeAppIds.split(","));
            includeAppIdSet = tempList.stream().map(String::trim).collect(Collectors.toSet());
        }
        properties.getAttachAppAuthInfoProperties().setExcludeAppIdSet(includeAppIdSet);
        DWHttpClientProperties.setProperties((DWHttpClientProperties)properties);
        return properties;
    }

    @Bean(value={"dw-httpclient-request-retry-handler"})
    @ConditionalOnMissingBean(name={"dw-httpclient-request-retry-handler"})
    public DWDefaultHttpRequestRetryHandler getDefaultHttpRequestRetryHandler(@Qualifier(value="dw-httpclient-retry-manager") DWHttpRetryManager retryManager) {
        return new DWDefaultHttpRequestRetryHandler(retryManager);
    }

    @Bean(value={"dw-httpclient-response-interceptor"})
    @ConditionalOnMissingBean(name={"dw-httpclient-response-interceptor"})
    @ConditionalOnProperty(value={"dwHttpRetryMappingMode"}, havingValue="legacy")
    public DWHttpResponseInterceptor getDWHttpResponseInterceptor(@Qualifier(value="dw-httpclient-retry-manager") DWHttpRetryManager retryManager) {
        return new DWHttpResponseInterceptor(retryManager);
    }

    @Bean(value={"dw-httpclient-response-retry-strategy"})
    @ConditionalOnMissingBean(name={"dw-httpclient-response-retry-strategy"})
    @ConditionalOnProperty(value={"dwHttpRetryMappingMode"}, havingValue="new", matchIfMissing=true)
    public DWDefaultAPIResponseRetryStrategy getDefaultAPIResponseRetryStrategy(@Qualifier(value="dw-httpclient-retry-manager") DWHttpRetryManager retryManager) {
        return new DWDefaultAPIResponseRetryStrategy(retryManager);
    }

    @Bean(value={"dw-httpclient-source"})
    @DependsOn(value={"dw-httpclient-retry-manager"})
    public HttpClient getHttpClientSource(DWHttpClientProperties httpClientProperties, ApplicationContext applicationContext, @Qualifier(value="dw-httpclient-request-retry-handler") HttpRequestRetryHandler httpRequestRetryHandler, @Autowired(required=false) @Qualifier(value="dw-httpclient-response-interceptor") HttpResponseInterceptor httpResponseInterceptor, @Autowired(required=false) @Qualifier(value="dw-httpclient-response-retry-strategy") ServiceUnavailableRetryStrategy httpResponseRetryStrategy, @Autowired(required=false) @Qualifier(value="dwDefaultMainExecWrapperFactory") DWMainExecWrapperFactory dwMainExecWrapperFactory) {
        Long maxIdleTime;
        if (httpResponseInterceptor == null && httpResponseRetryStrategy == null) {
            throw new NoSuchBeanDefinitionException(String.format("DWHttpClient Required Bean %s(type=%s) or %s(type=%s)", BEAN_NAME_DW_HTTPCLIENT_RESPONSE_RETRY_STRATEGY, ServiceUnavailableRetryStrategy.class.getName(), BEAN_NAME_DW_HTTPCLIENT_RESPONSE_INTERCEPTOR, HttpResponseInterceptor.class.getName()));
        }
        if (httpClientProperties == null) {
            httpClientProperties = new DWHttpClientProperties();
        }
        HttpRoutePlanner routePlanner = null;
        try {
            routePlanner = (HttpRoutePlanner)applicationContext.getBean("dwAttemptHttpLoadbalanceRoute", DWAttemptHttpLoadbalanceRoute.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            try {
                routePlanner = (HttpRoutePlanner)applicationContext.getBean("dwDefaultHttpLoadbalanceRoute", DWDefaultHttpLoadbalanceRoute.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.closeIdleConnections(120L, TimeUnit.SECONDS);
        cm.setMaxTotal(httpClientProperties.getMaxTotal());
        cm.setDefaultMaxPerRoute(httpClientProperties.getDefaultMaxPerRoute());
        cm.setValidateAfterInactivity(httpClientProperties.getValidateAfterInactivity());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(httpClientProperties.getConnectTimeout()).setSocketTimeout(httpClientProperties.getSocketTimeout()).setConnectionRequestTimeout(httpClientProperties.getConnectionRequestTimeout()).build();
        ConnectionKeepAliveStrategy keepAliveStrategy = httpClientProperties.getConnectionKeepAliveStrategy();
        if (keepAliveStrategy == null) {
            keepAliveStrategy = new DWConnectKeepAliveStrategy();
        }
        HttpClientBuilder httpClientBuilder = null;
        httpClientBuilder = dwMainExecWrapperFactory == null ? HttpClients.custom() : DWHttpClientBuild.create((DWMainExecWrapper)dwMainExecWrapperFactory.getWrapper());
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new DWSecurityInterceptor()).setRetryHandler(httpRequestRetryHandler).setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy(keepAliveStrategy);
        if (httpResponseRetryStrategy != null) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(httpResponseRetryStrategy);
        } else {
            httpClientBuilder.addInterceptorLast(httpResponseInterceptor);
        }
        if (httpClientProperties.isEvictExpiredConnections()) {
            httpClientBuilder.evictExpiredConnections();
        }
        if ((maxIdleTime = httpClientProperties.getEvictIdleConnectionsMaxIdleTime()) != null) {
            httpClientBuilder.evictIdleConnections(maxIdleTime.longValue(), TimeUnit.MILLISECONDS);
        }
        if (null != routePlanner) {
            httpClientBuilder.setRoutePlanner(routePlanner);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }

    @Bean(value={"dw-httpclient"})
    @DependsOn(value={"dw-http-client-properties", "dw-httpclient-retry-backoff-deserializer"})
    public DWHttpClient getDWHttpClient(@Qualifier(value="dw-httpclient-source") HttpClient source, DWAdapterConfigUtils adapterConfigUtils, @Value(value="${dwloadBalanceEnable:#{null}}") String loadBalanceEnableStr, @Value(value="${dwhttpClient.loadbalance.enable:#{null}}") String httpclientLoadBalanceEnbaleStr) {
        DWHttpClient dwHttpClient = new DWHttpClient(source);
        dwHttpClient.initLoadBalance(loadBalanceEnableStr, httpclientLoadBalanceEnbaleStr);
        return dwHttpClient;
    }

    @Bean(value={"dw-httpclient-retry-backoff-deserializer"})
    public DWHttpRetryBackoffDeserializer getBackoffDeserializer(DWAdapterConfigUtils adapterConfigUtils) {
        DWHttpRetryConditionDeserializer.register(DWHttpRetryResponseStatusesCondition.class);
        DWHttpRetryConditionDeserializer.register(DWHttpRetryExMessageKeywordsCondition.class);
        DWGsonProvider.registerTypeAdapter(DWHttpRetryCondition.class, (Object)new DWHttpRetryConditionDeserializer());
        DWHttpRetryBackoffDeserializer.register((String)"simple", DWHttpRetrySimpleBackoff.class);
        DWHttpRetryBackoffDeserializer.register((String)"arithmeticSequence", DWHttpRetryArithmeticSequenceBackoff.class);
        return new DWHttpRetryBackoffDeserializer();
    }

    @Bean(value={"dw-httpclient-retry-config-provider"})
    @ConditionalOnMissingBean(name={"dw-httpclient-retry-config-provider"})
    @DependsOn(value={"dw-httpclient-retry-backoff-deserializer"})
    public DWHttpRetryConfigProvider getRetryConfigProvider() {
        return new DWDAPPlatformHttpRetryConfigProvider();
    }

    @Bean(value={"dw-httpclient-api-info-provider"})
    @ConditionalOnMissingBean(name={"dw-httpclient-api-info-provider"})
    public DWHttpAPIInfoProvider getApiInfoProvider(Environment environment) {
        String mdcUrl = environment.getProperty("mdcUrl");
        return new DWApolloHttpAPIInfoProvider(mdcUrl);
    }

    @Bean(value={"dw-httpclient-host-api-mapper"})
    @ConditionalOnMissingBean(name={"dw-httpclient-host-api-mapper"})
    public DWHTTPHostAppIdMapper getDWHTTPHostAppIdMapper(AbstractEnvironment abstractEnvironment) {
        DWSpringPKVRuleHostAppIdMapMapper mapper = new DWSpringPKVRuleHostAppIdMapMapper((ConfigurableEnvironment)abstractEnvironment);
        return mapper;
    }

    @Bean(value={"dw-httpclient-retry-properties"})
    @ConditionalOnMissingBean(name={"dw-httpclient-retry-properties"})
    public DWHttpRetryProperties getHttpRetryProperties(Environment environment) {
        DWHttpRetryProperties retryProperties = new DWHttpRetryProperties();
        retryProperties.setEaiAPIDefaultConfigEnabled(Boolean.parseBoolean(environment.getProperty("dwhttpclient.retry.eai-api.default-config.enabled", "true")));
        retryProperties.setGeneralAPIDefaultConfigEnabled(Boolean.parseBoolean(environment.getProperty("dwhttpclient.retry.general-api.default-config.enabled", "false")));
        retryProperties.setUserConfigCheckIdempotence(Boolean.parseBoolean(environment.getProperty("dwhttpclient.retry.user-config.check-idempotence", "false")));
        retryProperties.setForceToRetryNoHttpResponseException(Boolean.parseBoolean(environment.getProperty("dwhttpclient.retry.force-to-retry-no-http-response-exception.enabled", "true")));
        retryProperties.setForceToRetryUnknownHostException(Boolean.parseBoolean(environment.getProperty("dwhttpclient.retry.force-to-retry-unknown-host-exception.enabled", "true")));
        return retryProperties;
    }

    @Bean(value={"dw-httpclient-retry-manager"})
    @ConditionalOnMissingBean(name={"dw-httpclient-retry-manager"})
    public DWHttpRetryManager getHttpRetryManager(@Qualifier(value="dw-httpclient-retry-config-provider") DWHttpRetryConfigProvider retryConfigProvider, @Qualifier(value="dw-httpclient-api-info-provider") DWHttpAPIInfoProvider apiInfoProvider, @Qualifier(value="dw-httpclient-host-api-mapper") DWHTTPHostAppIdMapper hostAppIdMapper, @Qualifier(value="dw-httpclient-retry-properties") DWHttpRetryProperties retryProperties) {
        DWHttpRetryManager manager = new DWHttpRetryManager(retryConfigProvider, apiInfoProvider, hostAppIdMapper, retryProperties);
        DWHttpRetryManager.setDWHttpRetryManager((DWHttpRetryManager)manager);
        return manager;
    }
}

