/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.condition;

import com.digiwin.http.client.condition.DWAbstractHttpRetryExceptionCondition;
import com.digiwin.http.client.condition.DWHttpRetryCondition;
import com.digiwin.http.client.condition.DWHttpRetryConditionAlias;
import com.digiwin.http.client.condition.DWHttpRetryConditionMatchResult;
import java.io.IOException;
import java.util.Set;

@DWHttpRetryConditionAlias(value="exceptionMsgKeywords")
public class DWHttpRetryExMessageKeywordsCondition
extends DWAbstractHttpRetryExceptionCondition {
    private Set<String> messageKeywords;

    @Override
    protected DWHttpRetryConditionMatchResult matchCore(IOException ex) {
        String message = ex.getMessage();
        if (message == null) {
            return null;
        }
        if (this.messageKeywords == null) {
            return null;
        }
        boolean retry = false;
        String reason = null;
        for (String keyword : this.messageKeywords) {
            if (!message.contains(keyword)) continue;
            retry = true;
            break;
        }
        DWHttpRetryConditionMatchResult result = null;
        if (retry) {
            reason = String.format("IOException[class=%s, message=%s], matched key words: %s", ex.getClass().getName(), ex.getMessage(), this.messageKeywords);
            result = new DWHttpRetryConditionMatchResult((DWHttpRetryCondition)this, reason, this.checkIdempotence());
        }
        return result;
    }
}

