/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.serializer;

import com.digiwin.app.container.exceptions.DWSingletonAlreadyExistsException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.http.client.DWHttpRetryBackoff;
import com.digiwin.http.client.DWHttpRetrySimpleBackoff;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DWHttpRetryBackoffDeserializer
implements JsonDeserializer<DWHttpRetryBackoff> {
    private static final String KEY_FIELD = "type";
    private static DWHttpRetryBackoffDeserializer singleton;
    private static Map<String, Class<? extends DWHttpRetryBackoff>> backoffTypes;

    public DWHttpRetryBackoffDeserializer() {
        if (singleton != null) {
            throw new DWSingletonAlreadyExistsException((Object)this);
        }
        singleton = this;
        DWGsonProvider.registerTypeAdapter(DWHttpRetryBackoff.class, (Object)this);
    }

    public static synchronized <T extends DWHttpRetryBackoff> void register(String typeName, Class<T> backoffType) {
        Objects.requireNonNull(typeName);
        Objects.requireNonNull(backoffType);
        if (backoffType.isInterface()) {
            throw new IllegalArgumentException("backoffType can not be interface");
        }
        backoffTypes.put(typeName.toLowerCase(), backoffType);
    }

    public DWHttpRetryBackoff deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String typeName;
        Class<? extends DWHttpRetryBackoff> backoffType;
        JsonObject jsonObject = json.getAsJsonObject();
        boolean hasName = jsonObject.has(KEY_FIELD);
        if (hasName && (backoffType = backoffTypes.get(typeName = jsonObject.get(KEY_FIELD).getAsString().toLowerCase())) != null) {
            return (DWHttpRetryBackoff)context.deserialize((JsonElement)jsonObject, backoffType);
        }
        return (DWHttpRetryBackoff)context.deserialize((JsonElement)jsonObject, DWHttpRetrySimpleBackoff.class);
    }

    static {
        backoffTypes = new HashMap<String, Class<? extends DWHttpRetryBackoff>>();
    }
}

