/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryBackoff;

public class DWHttpRetrySimpleBackoff
implements DWHttpRetryBackoff {
    private long firstBackoff = 5000L;
    private long maxBackoff = 120000L;
    private float factor = 1.0f;

    public DWHttpRetrySimpleBackoff() {
    }

    public DWHttpRetrySimpleBackoff(long firstBackoff, long maxBackoff, int factor) {
        this.firstBackoff = firstBackoff;
        this.maxBackoff = maxBackoff;
        this.factor = factor;
    }

    public long calculate(int executionCount, long previousBackoff) {
        long backoff = executionCount == 1 ? this.firstBackoff : this.firstBackoff * (long)Math.pow(this.factor, executionCount);
        if (backoff > this.maxBackoff) {
            backoff = this.maxBackoff;
        }
        if (backoff < 0L) {
            return 0L;
        }
        return backoff;
    }
}

