/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.config.mdc;

import com.digiwin.http.client.exception.DWMDCResponseFailedException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class MDCUtil {
    private static Log log = LogFactory.getLog(MDCUtil.class);
    private static final String MDC_APIMETADATA_GET = "/restful/standard/mdc/ApiBaseInfo/Get";
    private static final String MDC_PARENTSERVICENAME_GET = "/restful/standard/mdc/ApiRelation/Get";
    private static String mdcBaseUrl = null;
    private static CloseableHttpClient closeableHttpClient;

    public static void setMDCUrl(String mdcUrl) {
        mdcBaseUrl = mdcUrl;
    }

    public static boolean getApiIdempotency(String apiName, String tenantId) {
        if (mdcBaseUrl == null || mdcBaseUrl.isEmpty()) {
            log.warn((Object)"DAP MDCUtil.mdcBaseUrl is null or empty! can't not get API idempotence!");
            return false;
        }
        String tURL = mdcBaseUrl + MDC_APIMETADATA_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("api_name", apiName);
        if (tenantId == null) {
            tenantId = "";
        }
        tJsonObject.addProperty("tenant_id", tenantId);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        try {
            HttpResponse tHttpResponse = MDCUtil.executeHttp((HttpUriRequest)tHttpPost);
            JsonObject tReturnJsonObject = MDCUtil.parseHttpResponseBody(tHttpResponse, tURL);
            MDCUtil.checkErrorCode(tReturnJsonObject);
            return tReturnJsonObject.getAsJsonObject("data").get("idempotency").getAsBoolean();
        }
        catch (DWMDCResponseFailedException e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]mdc get Api Idempotency fail;apiName:" + apiName + ", tenantId: " + tenantId + ", MDC RETURN error code:" + e.getErrorCode() + ", error message:" + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]mdc get Api Idempotency fail;apiName:" + apiName + ", tenantId: " + tenantId + ", e:{}"), (Throwable)e);
        }
        return false;
    }

    protected static void checkErrorCode(JsonObject returnObject) throws DWMDCResponseFailedException {
        JsonPrimitive errorCodeNode = returnObject.getAsJsonPrimitive("errorCode");
        if (null != errorCodeNode) {
            String errorCode = errorCodeNode.getAsString();
            String errorMessage = returnObject.getAsJsonPrimitive("errorMessage").getAsString();
            throw new DWMDCResponseFailedException(errorCode, errorMessage);
        }
    }

    public static HttpResponse executeHttp(HttpUriRequest httpRequest) throws Exception {
        return MDCUtil.executeHttp(httpRequest, true);
    }

    public static HttpResponse executeHttp(HttpUriRequest httpRequest, boolean idempotency) throws Exception {
        CloseableHttpClient tClient = MDCUtil.createHttpClient();
        int retryCount = 3;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502 || tStatusCode == 503) {
                    if (--retryCount <= 0 || !idempotency) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + String.valueOf(httpRequest.getURI()) + "]http status " + tStatusCode + ", and retry limit has been exceeded."));
                        return tResponse;
                    }
                    log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + String.valueOf(httpRequest.getURI()) + "]http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + String.valueOf(e1)));
                        return tResponse;
                    }
                }
                return tResponse;
            }
            catch (NoHttpResponseException e) {
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + String.valueOf(httpRequest.getURI()) + "]HTTP request NoHttpResponseException:{}"), (Throwable)e);
                tClient = MDCUtil.reCreateHttpClient();
                retryCount = MDCUtil.retryExceptionCheck(retryCount, (Exception)((Object)e));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + String.valueOf(httpRequest.getURI()) + "]HTTP request Exception:{}" + String.valueOf(e)));
                retryCount = MDCUtil.retryExceptionCheck(retryCount, e);
                continue;
            }
            break;
        }
    }

    public static JsonObject parseHttpResponseBody(HttpResponse httpResponse, String url) throws Exception {
        String tBody = null;
        try {
            JsonParser tJsonParser = new JsonParser();
            tBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            return (JsonObject)tJsonParser.parse(tBody);
        }
        catch (Exception e) {
            if (url != null) {
                throw new Exception(String.format("%s. URL:[%s], response message:[%s]", e.getMessage(), url, tBody));
            }
            throw new Exception(String.format("%s. message:[%s]", e.getMessage(), tBody));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient createHttpClient() {
        Class<MDCUtil> clazz = MDCUtil.class;
        synchronized (MDCUtil.class) {
            if (closeableHttpClient == null) {
                PoolingHttpClientConnectionManager connManager;
                try {
                    SSLContext sslContext = SSLContexts.custom().build();
                    SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                    Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
                    connManager = new PoolingHttpClientConnectionManager(registry);
                }
                catch (Exception e) {
                    connManager = new PoolingHttpClientConnectionManager();
                }
                connManager.setMaxTotal(200);
                connManager.setDefaultMaxPerRoute(100);
                RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(12000).setConnectTimeout(11000).setConnectionRequestTimeout(9000).build();
                closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).build();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return closeableHttpClient;
        }
    }

    public static CloseableHttpClient reCreateHttpClient() {
        closeableHttpClient = null;
        return MDCUtil.createHttpClient();
    }

    protected static int retryExceptionCheck(int retryTimes, Exception e) throws Exception {
        log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]HTTP request retryExceptionCheck: retryTimes:" + retryTimes));
        if (--retryTimes <= 0) {
            throw e;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + String.valueOf(e1)));
            throw e;
        }
        return retryTimes;
    }
}

