/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.dap.component.iam.api.IamRequestContextProvider;
import com.dap.component.iam.api.IamResourceBundleProvider;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.http.client.exception.DWExternalAPIHttpFailedException;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class IAMHttpRequester {
    private static DWIAMProperties properties;

    IAMHttpRequester() {
    }

    public static void setProperties(DWIAMProperties properties) {
        IAMHttpRequester.properties = properties;
    }

    public static DWIAMProperties getProperties() {
        if (properties == null) {
            throw new DWRuntimeException("IAMHttpRequester properties is not ready, please contact DAP for this issue.");
        }
        return properties;
    }

    public static Object submit(ServiceModel model) throws Exception {
        Map<String, String> requestHeader = IAMHttpRequester.createRequestHeader(model);
        String requestBody = null;
        if (model.getParams() != null) {
            requestBody = IAMHttpRequester.createRequestBody(model.getParams());
        } else if (model.getBody() != null) {
            requestBody = IAMHttpRequester.createRequestBody(model.getBody());
        }
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setRequestMethod(model.getRequestMethod());
        requestModel.setHttpContext(model.getHttpContext());
        String iamUrl = IAMHttpRequester.getProperties().getUrl();
        requestModel.setUrl(iamUrl + model.getInvokeURL());
        HttpResponseModel responseModel = HttpRequester.submitRequest(requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            throw IAMHttpRequester.handleHttpStatus(requestModel, responseModel);
        }
        return responseModel;
    }

    public static HttpRequestModel getHttpRequestModel() {
        DWIAMProperties properties = IAMHttpRequester.getProperties();
        HttpRequestModel requestModel = new HttpRequestModel();
        requestModel.setContentType(properties.getContentType());
        requestModel.setCharSet(properties.getCharset());
        requestModel.setConnectionPoolRequestTimeout(properties.getConnectionRequestTimeout());
        requestModel.setConnectionTimeout(properties.getConnectionTimeout());
        requestModel.setSoTimeout(properties.getRequestSocketTimeout());
        requestModel.setEncode(properties.getEncode());
        requestModel.setMaxTotalConnections(properties.getConnectionMaxTotal());
        requestModel.setKeepAliveTimeout(properties.getKeepAliveTimeout());
        requestModel.setEvictExpiredConnections(properties.isEvictExpiredConnections());
        requestModel.setEvictIdleConnectionsMaxIdleTime(properties.getEvictIdleConnectionsMaxIdleTime());
        return requestModel;
    }

    public static String createRequestBody(Object params) throws Exception {
        Gson jsonParser = new Gson();
        return jsonParser.toJson(params);
    }

    public static Map<String, String> createRequestHeader(ServiceModel model) throws Exception {
        IamResourceBundleProvider resourceBundleProvider;
        Locale locale;
        HashMap<String, String> header = new HashMap<String, String>();
        DWIAMProperties properties = IAMHttpRequester.getProperties();
        header.put("Content-Type", properties.getContentType() + ";" + properties.getCharset());
        String iamApToken = properties.getAppToken();
        if (iamApToken.isEmpty()) {
            IamRequestContextProvider requestContextProvider = (IamRequestContextProvider)SpringContextUtils.getBean((String)"iamRequestContextProvider");
            iamApToken = requestContextProvider.getApToken("");
        }
        header.put("digi-middleware-auth-app", iamApToken);
        if (properties.isIAMTokenMode()) {
            header.put("digi-middleware-auth-user", model.getToken());
        }
        if ((locale = (resourceBundleProvider = (IamResourceBundleProvider)SpringContextUtils.getBean((String)"iamResourceBundleProvider")).getCurrentLocale()) != null) {
            header.put("Accept-Language", locale.toLanguageTag());
        }
        return header;
    }

    @Deprecated
    public static void handleHttpStatus(int httpStatusCode) throws Exception {
        if (httpStatusCode == 500) {
            throw new Exception("IAM \u7cfb\u7edf\u9519\u8bef\uff0c\u66f4\u591a\u8d44\u8baf\u8bf7\u67e5\u8be2\u7cfb\u7edf\u8bb0\u5f55!");
        }
        if (httpStatusCode == 503) {
            throw new Exception("IAM \u5916\u90e8\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u65e0\u6cd5\u8fde\u7ebf\u5230\u540e\u7aef\u8d44\u6599\u5e93!");
        }
        if (httpStatusCode == 406) {
            throw new Exception("IAM AP TOKEN \u932f\u8aa4!");
        }
    }

    public static DWException handleHttpStatus(HttpRequestModel requestModel, HttpResponseModel responseModel) throws Exception {
        IamResourceBundleProvider resourceBundleProvider = (IamResourceBundleProvider)SpringContextUtils.getBean((String)"iamResourceBundleProvider");
        String iamErrorMessage = resourceBundleProvider.getApplicationLayerMessage("10900", requestModel.getUrl(), requestModel.getRequestHeader().toString(), requestModel.getRequestBody(), responseModel.getHttpStatusCode(), responseModel.getResponseBody());
        boolean login = false;
        String errorCode = "10903";
        if (responseModel.getHttpStatusCode() == 406 || responseModel.getHttpStatusCode() == 401) {
            errorCode = "10904";
            login = true;
        }
        DWExternalAPIHttpFailedException exception = new DWExternalAPIHttpFailedException(errorCode, iamErrorMessage, requestModel.getUrl(), responseModel.getHttpStatusCode(), responseModel.getResponseBody());
        if (login) {
            exception.getInstructors().put("login", true);
        }
        return exception;
    }
}

