/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.dap.component.iam.api.IamSpringContextProvider;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.iam.DWIAMFuse;
import com.digiwin.iam.HttpConnectionManager;
import com.digiwin.iam.HttpRequestLogModel;
import com.digiwin.iam.HttpRequestLogger;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpResponseModel;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.context.ApplicationContext;

public class HttpRequester {
    private static Log log = LogFactory.getLog(HttpRequester.class);
    private static DWFuseOption defaultFuseOption = null;
    private static OutboundConfig defaultOutBoundConfig = null;

    HttpRequester() {
    }

    public static void setDefaultDWFuseOption(DWFuseOption defaultFuseOption) {
        HttpRequester.defaultFuseOption = defaultFuseOption;
    }

    public static void setDefaultOutBoundConfig(OutboundConfig defaultOutBoundConfig) {
        HttpRequester.defaultOutBoundConfig = defaultOutBoundConfig;
    }

    public static HttpResponseModel submitRequest(HttpRequestModel requestModel) throws Exception {
        HttpRequestLogModel logModel = new HttpRequestLogModel();
        logModel.setUrl(requestModel.getUrl());
        logModel.setRequestHeader(requestModel.getRequestHeader());
        logModel.setRequestBody(requestModel.getRequestBody());
        CloseableHttpClient client = HttpRequester.getCloseableHttpClient(requestModel);
        HttpRequestBase httpRequest = HttpRequester.generateHttpRequestBase(requestModel);
        logModel.setStartTime(LocalDateTime.now());
        OutboundConfig outboundConfig = HttpRequester.getOutboundConfig();
        CollectorRegistry collectorRegistry = null;
        try {
            IamSpringContextProvider springContextProvider = (IamSpringContextProvider)SpringContextUtils.getBean((String)"iamSpringContextProvider");
            ApplicationContext applicationContext = springContextProvider.getApplicatioSpringContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWIAM] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWIAM] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        DWIAMFuse eaiFuse = new DWIAMFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("client", (Object)client);
        fuseParameter.set("httpRequest", (Object)httpRequest);
        if (requestModel.getHttpContext() != null) {
            fuseParameter.set("httpContext", (Object)requestModel.getHttpContext());
        }
        DWFuseOption option = HttpRequester.getOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWIAM] option: " + String.valueOf(option)));
        DWFuseReturnResponse fuseReturn = DWFuseExecutor.execute((DWReturnFuse)eaiFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        HttpResponseModel response = (HttpResponseModel)fuseReturn.getResponse();
        String responseBody = response.getResponseBody();
        int httpStatusCode = response.getHttpStatusCode();
        logModel.setEndTime(LocalDateTime.now());
        logModel.setResponseBody(responseBody);
        logModel.setHttpStatusCode(httpStatusCode);
        HttpRequestLogger.log(logModel);
        return new HttpResponseModel(httpStatusCode, responseBody);
    }

    private static CloseableHttpClient getCloseableHttpClient(HttpRequestModel requestModel) throws Exception {
        return HttpConnectionManager.getHttpClient(requestModel);
    }

    private static HttpRequestBase generateHttpRequestBase(HttpRequestModel requestModel) throws Exception {
        HttpGet httpRequest = null;
        DWRequestMethod requestMethod = requestModel.getRequestMethod();
        if (requestMethod == DWRequestMethod.GET) {
            httpRequest = new HttpGet(requestModel.getUrl());
        } else if (requestMethod == DWRequestMethod.POST) {
            httpRequest = new HttpPost(requestModel.getUrl());
            StringEntity requestEntity = new StringEntity(requestModel.getRequestBody(), "utf-8");
            requestEntity.setContentType(requestModel.getContentType());
            requestEntity.setContentEncoding(requestModel.getEncode());
            ((HttpPost)httpRequest).setEntity((HttpEntity)requestEntity);
        } else {
            throw new DWException(String.format("API platform DWIAM component http method %s not support", requestMethod));
        }
        for (Map.Entry<String, String> header : requestModel.getRequestHeader().entrySet()) {
            httpRequest.addHeader(header.getKey(), header.getValue());
        }
        DWRequestHeaderUtils.attachAppAuthInfo((String)httpRequest.getURI().getHost(), (HttpRequest)httpRequest);
        return httpRequest;
    }

    private static DWFuseOption getOption() {
        if (defaultFuseOption == null) {
            throw new DWRuntimeException("DWFuse default option is not ready, please contact DAP for this issue.");
        }
        return defaultFuseOption;
    }

    private static OutboundConfig getOutboundConfig() {
        if (defaultOutBoundConfig == null) {
            throw new DWRuntimeException("DWFuse default outbound config is not ready, please contact DAP for this issue.");
        }
        return defaultOutBoundConfig;
    }
}

