/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.iot.mqtt.DWMqttClientFactory;
import com.digiwin.app.iot.mqtt.DWMqttProperties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class DWMqttConfiguration {
    private static final Log _log = LogFactory.getLog(DWMqttConfiguration.class);
    private static final String _CLASSTAG = "[DWMqttConfiguration]";
    private static DWMqttClientFactory dwMqttClientFactory;
    private static DWMqttClientFactory defaultDWMqttClientFactory;
    private static boolean mqttEnabled;

    public static DWMqttClientFactory getInstance() throws Exception {
        String password;
        DWMqttProperties properties = DWMqttProperties.getProperties();
        String host = properties.getHost();
        mqttEnabled = DWMqttConfiguration.configValid(host);
        if (!mqttEnabled) {
            throw new DWArgumentException("DWMqttConfiguration", "mqtt enabled is false");
        }
        if (defaultDWMqttClientFactory != null) {
            return defaultDWMqttClientFactory.clone();
        }
        dwMqttClientFactory = new DWMqttClientFactory();
        MqttConnectOptions connectionOptions = new MqttConnectOptions();
        String username = properties.getUsername();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            connectionOptions.setUserName(username);
        }
        if (StringUtils.isNotBlank((CharSequence)(password = properties.getPassword()))) {
            connectionOptions.setPassword(password.toCharArray());
        }
        connectionOptions.setCleanSession(properties.getCleanSession());
        connectionOptions.setAutomaticReconnect(properties.getAutoReconnect());
        dwMqttClientFactory.setServerURI(host);
        int mqttConnectTimeout = properties.getConnectTimeout();
        connectionOptions.setConnectionTimeout(mqttConnectTimeout);
        dwMqttClientFactory.setConnectTimeout(mqttConnectTimeout);
        dwMqttClientFactory.setTopicRetained(properties.getTopicRetained());
        String clientId = properties.getClientId();
        if (StringUtils.isBlank((CharSequence)clientId)) {
            clientId = UUID.randomUUID().toString();
        }
        dwMqttClientFactory.setClientId(clientId);
        dwMqttClientFactory.setTopicQos(properties.getTopicQos());
        dwMqttClientFactory.setWaitForCompletion(properties.getWaitForCompletion());
        dwMqttClientFactory.setConnectionOptions(connectionOptions);
        defaultDWMqttClientFactory = dwMqttClientFactory.clone();
        return dwMqttClientFactory;
    }

    public static DWMqttClientFactory getDefaultInstance() throws Exception {
        if (!mqttEnabled) {
            throw new DWArgumentException("DWMqttConfiguration", "mqtt enabled is false");
        }
        if (dwMqttClientFactory == null) {
            DWMqttConfiguration.getInstance();
        }
        DWMqttClientFactory newDefaultDWMqttClientFactory = defaultDWMqttClientFactory.clone();
        return newDefaultDWMqttClientFactory;
    }

    public static DWMqttClientFactory reload() throws Exception {
        dwMqttClientFactory = DWMqttConfiguration.getInstance();
        return dwMqttClientFactory;
    }

    private static boolean configValid(String ... property) {
        String mqttServerHost = property[0];
        boolean isMqttEnabled = false;
        if (StringUtils.isNotBlank((CharSequence)mqttServerHost) && !mqttServerHost.matches("^@(.*).@$")) {
            isMqttEnabled = true;
        }
        _log.info((Object)("[DWMqttConfiguration] platform.properties:mqttSrvHost:" + mqttServerHost + ", mqtt enabled=" + isMqttEnabled));
        return isMqttEnabled;
    }

    public static boolean isMqttEnabled() {
        return mqttEnabled;
    }

    public static void setMqttEnabled(boolean mqttEnabled) {
        DWMqttConfiguration.mqttEnabled = mqttEnabled;
    }

    public static void setDWMqttClientFactory(DWMqttClientFactory dwMqttClientFactory) {
        DWMqttConfiguration.dwMqttClientFactory = dwMqttClientFactory;
    }

    static {
        mqttEnabled = false;
    }
}

