/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.utils;

import com.digiwin.app.iot.mqtt.ClientType;
import com.digiwin.app.iot.mqtt.DWMqttClientFactory;
import com.digiwin.app.iot.mqtt.DWMqttConfiguration;
import com.digiwin.app.iot.mqtt.MqttActionType;
import com.digiwin.app.iot.mqtt.callback.DWMqttCallback;
import com.digiwin.app.iot.mqtt.model.DWMqttMessage;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DWMqttSyncUtil {
    private static final Log _log = LogFactory.getLog(DWMqttSyncUtil.class);
    private static int loopInterval = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object publishMessage(String topic, String clientId, String message) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        mqttMessage.setRetained(clientFactory.isTopicRetained());
        mqttMessage.setQos(clientFactory.getTopicQos());
        DWMqttMessage dwMqttMessage = new DWMqttMessage();
        dwMqttMessage.setAction(MqttActionType.PUBLISH.toString());
        IMqttClient mqttClient = (IMqttClient)clientFactory.createAndConnectClient(clientId, ClientType.SYNC);
        try {
            _log.debug((Object)("mqtt client(" + clientId + ") Publishing to..." + topic + ",payload=" + message));
            mqttClient.publish(topic, mqttMessage);
            _log.debug((Object)("mqtt client(" + clientId + ") Published"));
        }
        finally {
            if (mqttClient.isConnected()) {
                mqttClient.disconnect();
            }
            dwMqttMessage.setActionSuccess(true);
        }
        return dwMqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object subscribeMessage(String topic, String clientId) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        int qos = clientFactory.getTopicQos();
        DWMqttCallback dwMqttCallback = new DWMqttCallback(topic, qos);
        DWMqttMessage dwMqttMessage = new DWMqttMessage();
        dwMqttMessage.setAction(MqttActionType.SUBSCRIBE.toString());
        IMqttClient mqttClient = (IMqttClient)clientFactory.createAndConnectClient(clientId, ClientType.SYNC, (MqttCallback)dwMqttCallback);
        try {
            _log.debug((Object)("mqtt client(" + clientId + ") Subscribing ... " + topic));
            mqttClient.subscribe(topic, clientFactory.getTopicQos());
            MqttMessage mqttMessage = null;
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(loopInterval);
                Map responseMessage = (Map)dwMqttCallback.getNextMessage();
                if (responseMessage != null && responseMessage.containsKey("message")) {
                    String messageTopic = (String)responseMessage.get("topic");
                    mqttMessage = (MqttMessage)responseMessage.get("message");
                    String message = new String(mqttMessage.getPayload());
                    dwMqttMessage.setMessage(message);
                    _log.debug((Object)("-- mqtt(" + i + ")-- message topic=" + messageTopic + ", message=" + message));
                    break;
                }
                _log.debug((Object)("-- mqtt(" + i + ")--- message topic=null"));
            }
            dwMqttMessage.setActionSuccess(true);
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
            }
            _log.debug((Object)("mqtt client(" + clientId + ",topic=" + topic + ") Disconnected..."));
        }
        return dwMqttMessage;
    }
}

