/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt;

import com.digiwin.app.iot.mqtt.ClientType;
import com.digiwin.app.iot.mqtt.DWMqttAsyncClient;
import com.digiwin.app.iot.mqtt.DWMqttClient;
import com.digiwin.app.iot.mqtt.DWMqttDefaultClientFactory;
import com.digiwin.app.iot.mqtt.callback.DWMqttCallback;
import com.digiwin.app.iot.mqtt.config.DWMqttConfig;
import com.digiwin.app.iot.mqtt.config.IMqttConfig;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class DWMqttClientV2Factory
implements DWMqttDefaultClientFactory {
    private MqttClientPersistence persistence;
    private IMqttConfig mqttConfig;

    public DWMqttClientV2Factory() throws Exception {
        this.mqttConfig = DWMqttConfig.getDefaultMqttConfig().clone();
    }

    public DWMqttClientV2Factory(IMqttConfig dwMqttConfig) throws Exception {
        this.mqttConfig = dwMqttConfig;
    }

    public Object createAndConnectClient(String clientId, ClientType clientSyncType, MqttCallback mqttCallback) throws Exception {
        return switch (StringUtils.lowerCase((String)clientSyncType.toString())) {
            case "async" -> this.createAndConnectAsyncClient(clientId, mqttCallback);
            default -> this.createAndConnectMqttClient(clientId, mqttCallback);
        };
    }

    public IMqttClient createAndConnectMqttClient(String clientId, MqttClientPersistence persistence, MqttCallback callback) throws Exception {
        String serverURI = this.mqttConfig.getServerURI();
        MqttConnectOptions connectionOptions = this.mqttConfig.getConnectOptions();
        DWMqttClient mqttClient = new DWMqttClient(serverURI, clientId, persistence);
        this.beforeConnect((Object)mqttClient, callback);
        if (connectionOptions != null) {
            mqttClient.connect(connectionOptions);
        } else {
            mqttClient.connect();
        }
        return mqttClient;
    }

    public IMqttClient createAndConnectMqttClient(String clientId) throws Exception {
        return this.createAndConnectMqttClient(clientId, this.persistence, null);
    }

    public IMqttAsyncClient createAsyncMqttClient(String serverURI, String clientId) throws Exception {
        return new DWMqttAsyncClient(serverURI, clientId);
    }

    public IMqttAsyncClient createAndConnectAsyncClient(String clientId) throws Exception {
        return (IMqttAsyncClient)this.createAndConnectAsyncClient(clientId, null);
    }

    public IMqttAsyncClient createMqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws Exception {
        return new DWMqttAsyncClient(serverURI, clientId, persistence);
    }

    public IMqttAsyncClient createMqttAsyncClient(String clientId, MqttClientPersistence persistence) throws Exception {
        String serverURI = this.mqttConfig.getServerURI();
        return this.createMqttAsyncClient(serverURI, clientId, persistence);
    }

    public IMqttAsyncClient createMqttAsyncClient(String clientId) throws Exception {
        String serverURI = this.mqttConfig.getServerURI();
        return this.createMqttAsyncClient(serverURI, clientId, this.persistence);
    }

    @Override
    public Object createAndConnectClient(String clientId, ClientType clientSyncType) throws Exception {
        Object result = this.createAndConnectClient(clientId, clientSyncType, null);
        return result;
    }

    public Object createAndConnectAsyncClient(String clientId, MqttCallback mqttCallback) throws Exception {
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        String serverURI = this.mqttConfig.getServerURI();
        DWMqttAsyncClient mqttClient = new DWMqttAsyncClient(serverURI, clientId, this.persistence);
        this.beforeConnect((Object)mqttClient, mqttCallback);
        MqttConnectOptions connectionOptions = this.mqttConfig.getConnectOptions();
        long waitForCompletion = this.mqttConfig.getWaitForCompletion();
        IMqttToken connectedMqttToken = connectionOptions != null ? mqttClient.connect(connectionOptions) : mqttClient.connect();
        if (connectedMqttToken != null && waitForCompletion > 0L) {
            connectedMqttToken.waitForCompletion(waitForCompletion);
        }
        return mqttClient;
    }

    public IMqttClient createAndConnectMqttClient(String clientId, MqttCallback mqttCallback) throws Exception {
        String serverURI = this.mqttConfig.getServerURI();
        DWMqttClient mqttClient = new DWMqttClient(serverURI, clientId, this.persistence);
        this.beforeConnect((Object)mqttClient, mqttCallback);
        MqttConnectOptions connectionOptions = this.mqttConfig.getConnectOptions();
        if (connectionOptions != null) {
            mqttClient.connect(connectionOptions);
        } else {
            mqttClient.connect();
        }
        return mqttClient;
    }

    public void beforeConnect(Object mqttClient, MqttCallback mqttCallback) {
        if (mqttCallback != null && mqttClient != null) {
            if (mqttCallback instanceof DWMqttCallback) {
                ((DWMqttCallback)mqttCallback).setMqttClient(mqttClient);
            }
            if (mqttClient instanceof IMqttAsyncClient) {
                ((IMqttAsyncClient)mqttClient).setCallback(mqttCallback);
            } else if (mqttClient instanceof IMqttClient) {
                ((IMqttClient)mqttClient).setCallback(mqttCallback);
            }
        }
    }

    @Override
    @Deprecated
    public String getClientId() {
        return this.mqttConfig.getClientId();
    }

    public DWMqttConfig getMqttConfig() {
        return (DWMqttConfig)this.mqttConfig;
    }

    public void setMqttConfig(DWMqttConfig mqttConfig) {
        this.mqttConfig = mqttConfig;
    }
}

