/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.iot;

import com.digiwin.app.iot.mqtt.DWMqttConfiguration;
import com.digiwin.app.iot.mqtt.DWMqttProperties;
import com.digiwin.app.iot.mqtt.config.DWMqttConfig;
import java.util.Objects;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWIOTAutoConfiguration {
    @Bean(value={"dw-mqtt-properties"})
    public DWMqttProperties getProperties(Environment environment) {
        DWMqttProperties properties = new DWMqttProperties();
        properties.setHost(environment.getProperty("mqttSrvHost"));
        properties.setUsername(environment.getProperty("mqttSrvUsername", ""));
        properties.setPassword(environment.getProperty("mqttSrvPassword", ""));
        properties.setAutoReconnect(Boolean.parseBoolean(environment.getProperty("mqttSrvReconnect", "true")));
        properties.setCleanSession(Boolean.parseBoolean(environment.getProperty("mqttSrvCleanSession", "false")));
        properties.setTopicRetained(Boolean.parseBoolean(environment.getProperty("mqttTopicRetained", "true")));
        properties.setClientId(environment.getProperty("mqttSrvClientId", "superman999"));
        String mqttSrvConnectTimeoutString = environment.getProperty("mqttSrvConnectTimeout", "5000");
        if (mqttSrvConnectTimeoutString.isEmpty() || Objects.equals("@mqttSrvConnectTimeout@", mqttSrvConnectTimeoutString)) {
            mqttSrvConnectTimeoutString = "5000";
        }
        properties.setConnectTimeout(Integer.parseInt(mqttSrvConnectTimeoutString));
        String mqttTopicQosString = environment.getProperty("mqttTopicQos", "1");
        if (mqttTopicQosString.isEmpty() || Objects.equals("@mqttTopicQos@", mqttTopicQosString)) {
            mqttTopicQosString = "1";
        }
        properties.setTopicQos(Integer.parseInt(mqttTopicQosString));
        String mqttWaitForCompletionString = environment.getProperty("mqttWaitForCompletion", "10000");
        if (mqttWaitForCompletionString.isEmpty() || Objects.equals("@mqttWaitForCompletion@", mqttWaitForCompletionString)) {
            mqttWaitForCompletionString = "10000";
        }
        properties.setWaitForCompletion(Long.parseLong(mqttWaitForCompletionString));
        DWMqttProperties.setProperties((DWMqttProperties)properties);
        return properties;
    }

    @Bean
    public DWMqttConfiguration mqttConfiguration() {
        return new DWMqttConfiguration();
    }

    @Bean
    public DWMqttConfig mqttConfig() {
        return new DWMqttConfig();
    }
}

