/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DWDateDeserializer
implements JsonDeserializer<Date> {
    private String datePattern;

    public DWDateDeserializer(String datePattern) {
        this.datePattern = datePattern;
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String jsonStr = json.getAsString();
        if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern);
                return dateFormat.parse(jsonStr);
            }
            catch (Exception e) {
                throw new JsonParseException("Date String not match pattern " + this.datePattern);
            }
        }
        return null;
    }
}

