/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.strategy;

import com.dap.component.json.api.JsonRequestContextProvider;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.view.DWViewConfig;
import com.digiwin.app.service.view.DWViewConfigs;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class DWViewFieldFilter {
    public static String HEADER_KEY_DIGI_JSON_VIEW = "digi-json-view";
    public static String CONTEXT_DATA_KEY_TARGET_SOURCE_METHOD = "targetSourceMethod";
    public static String CONTEXT_DATA_KEY_CURRENT_VIEW_FILTER = "digi-json-view-field-filter";
    private String viewName;
    private String[] include;
    private String[] exclude;

    private DWViewFieldFilter(DWViewConfig configuration) {
        this.viewName = configuration.name();
        this.include = configuration.include();
        this.exclude = configuration.exclude();
    }

    public boolean shouldFilter(String fieldName) {
        if (this.include.length > 0) {
            for (String includeKey : this.include) {
                if (!includeKey.equalsIgnoreCase(fieldName)) continue;
                return false;
            }
            return true;
        }
        for (String excludeKey : this.exclude) {
            if (!excludeKey.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public Map filter(Map source) {
        if (source.isEmpty()) {
            return source;
        }
        LinkedHashMap filterMap = new LinkedHashMap();
        for (Object key : source.keySet()) {
            for (String excludeKey : this.exclude) {
                if (excludeKey.equalsIgnoreCase(key.toString())) continue;
                filterMap.put((String)key, source.get(key));
            }
        }
        return filterMap;
    }

    public static DWViewFieldFilter getFromServiceContext() {
        JsonRequestContextProvider requestContextProvider = (JsonRequestContextProvider)SpringContextUtils.getBean((String)"jsonRequestContextProvider");
        return requestContextProvider.getContextDataKeyCurrentViewFilter();
    }

    private static DWViewFieldFilter createIfNeeded() {
        Method method;
        JsonRequestContextProvider requestContextProvider = (JsonRequestContextProvider)SpringContextUtils.getBean((String)"jsonRequestContextProvider");
        if (requestContextProvider.isRequestHeaderContainDigiJsonView() && (method = requestContextProvider.getContextDataKeyTargetSourceMethod()) != null) {
            String viewName = requestContextProvider.getRequestHeaderDigiJsonView();
            if (viewName == null) {
                return null;
            }
            DWViewConfig[] configurationArray = null;
            if (method.isAnnotationPresent(DWViewConfig.class)) {
                configurationArray = new DWViewConfig[]{method.getAnnotation(DWViewConfig.class)};
            } else if (method.isAnnotationPresent(DWViewConfigs.class)) {
                DWViewConfigs configurations = method.getAnnotation(DWViewConfigs.class);
                configurationArray = configurations.value();
            }
            DWViewConfig targetViewConfiguration = null;
            if (configurationArray != null) {
                for (DWViewConfig configuration : configurationArray) {
                    if (!viewName.equalsIgnoreCase(configuration.name())) continue;
                    targetViewConfiguration = configuration;
                    break;
                }
            }
            return DWViewFieldFilter.createFilter(method, targetViewConfiguration);
        }
        return null;
    }

    private static DWViewFieldFilter createFilter(Method method, DWViewConfig viewConfig) {
        if (viewConfig == null) {
            return null;
        }
        if (viewConfig.include().length != 0 && viewConfig.exclude().length != 0) {
            throw new DWRuntimeException(String.format("Method(name=%s) DWViewConfig(name=%s) setting both the include and exclude properties is not allowed.", method.getName(), viewConfig.name()));
        }
        return new DWViewFieldFilter(viewConfig);
    }

    public static boolean updateCurrentViewFilterContextData() {
        DWViewFieldFilter fieldFilter = DWViewFieldFilter.createIfNeeded();
        JsonRequestContextProvider requestContextProvider = (JsonRequestContextProvider)SpringContextUtils.getBean((String)"jsonRequestContextProvider");
        requestContextProvider.setContextDataKeyCurrentViewFilter(fieldFilter);
        return fieldFilter != null;
    }

    public static boolean clearCurrentViewFilterContextData() {
        JsonRequestContextProvider requestContextProvider = (JsonRequestContextProvider)SpringContextUtils.getBean((String)"jsonRequestContextProvider");
        return requestContextProvider.removeContextDataKeyCurrentViewFilter() != null;
    }
}

