/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class DWNumberDeserializer
implements JsonDeserializer<Number> {
    public Number deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String jsonStr = json.getAsString();
        if (Integer.TYPE == typeOfT || Integer.class == typeOfT) {
            if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
                return json.getAsInt();
            }
            if (Integer.TYPE == typeOfT) {
                return 0;
            }
        }
        if (Long.TYPE == typeOfT || Long.class == typeOfT) {
            if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
                return json.getAsLong();
            }
            if (Long.TYPE == typeOfT) {
                return 0L;
            }
        }
        if (Float.TYPE == typeOfT || Float.class == typeOfT) {
            if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
                return Float.valueOf(json.getAsFloat());
            }
            if (Float.TYPE == typeOfT) {
                return Float.valueOf(0.0f);
            }
        }
        if (Double.TYPE == typeOfT || Double.class == typeOfT) {
            if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
                return json.getAsDouble();
            }
            if (Double.TYPE == typeOfT) {
                return 0.0;
            }
        }
        if (BigDecimal.class == typeOfT && StringUtils.isNotEmpty((CharSequence)jsonStr)) {
            return json.getAsBigDecimal();
        }
        return null;
    }
}

