/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.json.DWJsonConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@DependsOn(value={"jsonRequestContextProvider", "dw-spring-context-utils"})
@Configuration
public class DWJsonAutoConfiguration {
    static final String KEY_DATE_TIME_FORMAT_OLD = "dap.json.dateformat";
    static final String KEY_DATE_TIME_FORMAT_NEW = "dap.json.date-time-format";
    static final String KEY_SERIALIZE_NULL_OLD = "dwJsonSerializeNulls";
    static final String KEY_SERIALIZE_NULL_NEW = "dap.json.serialize-null";
    static final String KEY_NUMBER_PROCESSOR_NAME = "dap.json.number-processor-name";
    static final String KEY_DESERIALIZE_EMPTY_STR_TO_NULL_OLD = "dwJsonEmptyStrToNullEnabled";
    static final String KEY_DESERIALIZE_EMPTY_STR_TO_NULL_NEW = "dap.json.deserialize-empty-str-to-null";
    static final String KEY_STANDARD_RESULT_NULL_TO_EMPTY_STR = "dap.json.standard-result-null-to-empty-str";
    static final String KEY_NUMBER_TO_DECIMAL_DIGITS = "dap.json.number-to-decimal-digits";

    @Bean(value={"dw-json-config"})
    public DWJsonConfig dwJsonConfig(Environment environment) {
        String serializeNull;
        String dateTimeFormat = environment.getProperty(KEY_DATE_TIME_FORMAT_OLD);
        if (null == dateTimeFormat || dateTimeFormat.trim().isEmpty()) {
            dateTimeFormat = environment.getProperty(KEY_DATE_TIME_FORMAT_NEW, "yyyy/MM/dd HH:mm:ss");
        }
        if (null == (serializeNull = environment.getProperty(KEY_SERIALIZE_NULL_OLD)) || serializeNull.trim().isEmpty()) {
            serializeNull = environment.getProperty(KEY_SERIALIZE_NULL_NEW, "true");
        }
        String numberProcessorName = environment.getProperty(KEY_NUMBER_PROCESSOR_NAME, "");
        String deserializeEmptyStrToNull = environment.getProperty(KEY_DESERIALIZE_EMPTY_STR_TO_NULL_OLD);
        if (null == deserializeEmptyStrToNull || deserializeEmptyStrToNull.trim().isEmpty()) {
            deserializeEmptyStrToNull = environment.getProperty(KEY_DESERIALIZE_EMPTY_STR_TO_NULL_NEW, "false");
        }
        String nullToEmptyStr = environment.getProperty(KEY_STANDARD_RESULT_NULL_TO_EMPTY_STR, "true");
        String numberToDecimalDigits = environment.getProperty(KEY_NUMBER_TO_DECIMAL_DIGITS, "2");
        DWJsonConfig jsonConfig = new DWJsonConfig();
        DWJsonConfig.setDateTimeFormat((String)dateTimeFormat);
        DWJsonConfig.setSerializeNull((Boolean)Boolean.parseBoolean(serializeNull));
        DWJsonConfig.setNumberProcessorName((String)numberProcessorName);
        DWJsonConfig.setDeserializeEmptyStrToNull((Boolean)Boolean.parseBoolean(deserializeEmptyStrToNull));
        DWJsonConfig.setStandardResultNullToEmptyStr((boolean)Boolean.parseBoolean(nullToEmptyStr));
        DWJsonConfig.setNumberToDecimalDigits((int)Integer.parseInt(numberToDecimalDigits));
        return jsonConfig;
    }
}

