/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson.serializer;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.container.exceptions.DWSingletonAlreadyExistsException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWFile;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class DWFileSerializer
implements JsonSerializer<DWFile> {
    private static DWFileSerializer singleton;

    public DWFileSerializer() {
        if (singleton != null) {
            throw new DWSingletonAlreadyExistsException((Object)this);
        }
        singleton = this;
        DWGsonProvider.registerTypeAdapter(DWFile.class, (Object)this);
    }

    public JsonElement serialize(DWFile src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        try {
            result.add("fileName", context.serialize((Object)src.getFileName()));
            result.add("fileByteArray", context.serialize((Object)src.getFileByteArray()));
        }
        catch (Exception e) {
            throw new DWRuntimeException("DWFileSerializer serialize DWFile fialed!");
        }
        return result;
    }
}

