/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate.v2;

import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.candidate.v2.AbstractApiCandidateV2;
import com.digiwin.loadbalance.scan.metadata.compress.DWCommonApiMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;

public class ControllerApiCandidateV2
extends AbstractApiCandidateV2<DWCommonApiMetadata> {
    private Log log = LogFactory.getLog(ControllerApiCandidateV2.class);
    private String[] pathAnnotationNameArrary = new String[]{GetMapping.class.getName(), PostMapping.class.getName(), PutMapping.class.getName(), DeleteMapping.class.getName()};
    private Map<RequestMethod, String> requestMethodStringMap = new HashMap(){
        {
            this.put(RequestMethod.GET, GetMapping.class.getName());
            this.put(RequestMethod.POST, PostMapping.class.getName());
            this.put(RequestMethod.PUT, PutMapping.class.getName());
            this.put(RequestMethod.DELETE, DeleteMapping.class.getName());
            this.put(RequestMethod.PATCH, PatchMapping.class.getName());
        }
    };

    @Override
    public List<DWCommonApiMetadata> resolverPathRegex(MetadataReader metadataReader, String rootPath) {
        ArrayList<DWCommonApiMetadata> apiMetadataList = new ArrayList<DWCommonApiMetadata>();
        if (metadataReader.getAnnotationMetadata().hasAnnotation(RequestMapping.class.getName())) {
            HashSet<RequestMethod> allowMethod = new HashSet<RequestMethod>();
            Map classAttributes = metadataReader.getAnnotationMetadata().getAnnotationAttributes(RequestMapping.class.getName());
            RequestMethod[] classMethods = (RequestMethod[])classAttributes.get("method");
            allowMethod.addAll(Arrays.asList(classMethods));
            String[] classPathArray = (String[])classAttributes.get("path");
            boolean classVersionAble = metadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName());
            metadataReader.getAnnotationMetadata().getAnnotatedMethods(RequestMapping.class.getName()).stream().forEach(methodMetadata -> {
                String requestMethodString;
                Map annotationAttributes;
                Map methodAnnotationAttributes = methodMetadata.getAnnotationAttributes(RequestMapping.class.getName());
                Object[] methodPathArray = (String[])methodAnnotationAttributes.get("path");
                RequestMethod[] methods = (RequestMethod[])methodAnnotationAttributes.get("method");
                if (ArrayUtils.isEmpty((Object[])methodPathArray) && methods.length == 1 && Objects.nonNull(annotationAttributes = methodMetadata.getAnnotationAttributes(requestMethodString = this.requestMethodStringMap.get(methods[0])))) {
                    String[] methodPaths = (String[])annotationAttributes.get("path");
                    allowMethod.add(methods[0]);
                    int[] tags = this.getTags(allowMethod, this.appVersionAble() && (this.allVersionAble() || classVersionAble || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                    apiMetadataList.addAll(this.buildApi(classPathArray, methodPaths, tags));
                    return;
                }
                allowMethod.addAll(Arrays.asList(methods));
                int[] tags = this.getTags(allowMethod, this.appVersionAble() && (this.allVersionAble() || classVersionAble || methodMetadata.isAnnotated(DWVersionable.class.getName())));
                apiMetadataList.addAll(this.buildApi(classPathArray, (String[])methodPathArray, tags));
            });
        }
        return apiMetadataList;
    }

    private List<DWCommonApiMetadata> buildApi(String[] classPathArray, String[] methodPathArray, int[] tags) {
        if (ArrayUtils.isEmpty((Object[])classPathArray)) {
            classPathArray = new String[]{""};
        }
        if (ArrayUtils.isEmpty((Object[])methodPathArray)) {
            methodPathArray = new String[]{""};
        }
        ArrayList<DWCommonApiMetadata> apiMetadataList = new ArrayList<DWCommonApiMetadata>();
        for (String classPath : classPathArray) {
            for (String methodPath : methodPathArray) {
                UriComponentsBuilder pathUriComponentsBuilder = UriComponentsBuilder.newInstance().path("/");
                if (StringUtils.isNotBlank((CharSequence)classPath) && StringUtils.isNotBlank((CharSequence)methodPath)) {
                    pathUriComponentsBuilder.path("/").path(classPath).path("/").path(methodPath);
                } else if (StringUtils.isBlank((CharSequence)classPath)) {
                    pathUriComponentsBuilder.path("/").path(classPath).path("/").path(methodPath);
                } else {
                    pathUriComponentsBuilder.path("/").path(classPath);
                }
                DWCommonApiMetadata dwCommonApiMetadata = new DWCommonApiMetadata(pathUriComponentsBuilder.build().getPath(), tags);
                apiMetadataList.add(dwCommonApiMetadata);
            }
        }
        return apiMetadataList;
    }

    @Override
    public List<DWCommonApiMetadata> resolver(List<DWTargetResource> targetResourceList) throws IOException {
        ArrayList<DWCommonApiMetadata> metadataList = new ArrayList<DWCommonApiMetadata>();
        targetResourceList.stream().forEach(targetResource -> {
            for (Resource resource : targetResource.getResources()) {
                this.log.info((Object)("ControllerApiCandidateV2 resource:" + resource + " begin"));
                MetadataReader metadataReader = null;
                try {
                    InputStream inputStream = resource.getInputStream();
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    ByteArrayResource classbytesResource = new ByteArrayResource((byte[])bytes.clone());
                    metadataReader = this.getMetadataReaderFactory().getMetadataReader((Resource)classbytesResource);
                    metadataList.addAll(this.resolverPathRegex(metadataReader, targetResource.getPrefix()));
                    inputStream.close();
                }
                catch (Throwable e) {
                    this.log.error((Object)("getMetadataReader faile resource:" + resource.getDescription() + "classResouce:" + resource.getDescription()), e);
                }
                this.log.info((Object)("ControllerApiCandidateV2 resource:" + resource + " end"));
            }
        });
        return metadataList;
    }

    @Override
    public int[] processBaseTages(int[] baseTags) {
        if (ArrayUtils.isEmpty((int[])baseTags)) {
            throw new IllegalArgumentException("tags must not be empty");
        }
        int baseTag = baseTags[0];
        baseTags[0] = baseTag += 16;
        return baseTags;
    }
}

