/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher.v2;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.loadbalance.matcher.v2.DWAbstractMatcherV2;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Order(value=2147482647)
public class EAICallBackMatcherV2
extends DWAbstractMatcherV2 {
    AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static Log log = LogFactory.getLog(EAICallBackMatcherV2.class);
    private String eaiCallbackPath = null;
    NacosServerListWatcher nacosServerListWatcher;
    Environment environment;
    DiscoveryClient discoveryClient;

    public EAICallBackMatcherV2(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        this.nacosServerListWatcher = nacosServerListWatcher;
        this.environment = environment;
        this.discoveryClient = discoveryClient;
        String serviceName = environment.getProperty("loadbalancer.client.name");
        List instances = discoveryClient.getInstances(serviceName);
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            String eaiRestfulCallbackPath;
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
            this.eaiCallbackPath = eaiRestfulCallbackPath = (String)serviceInstance.getMetadata().get("eai.callbackPath");
        }
        try {
            nacosServerListWatcher.watch(serviceName, event -> {
                List nameInstances;
                if (event instanceof NamingEvent && !CollectionUtils.isEmpty((Collection)(nameInstances = ((NamingEvent)event).getInstances()))) {
                    Instance instance = (Instance)nameInstances.get(0);
                    String eaiRestfulCallbackPath = (String)instance.getMetadata().get("eai.callbackPath");
                    String contextPath = instance.getMetadata().getOrDefault("server_context_path", "");
                    UriComponents eaiUriComponents = UriComponentsBuilder.newInstance().path("/").path(contextPath).path("/").path(eaiRestfulCallbackPath).build();
                    this.eaiCallbackPath = eaiUriComponents.getPath();
                }
            });
        }
        catch (NacosException e) {
            log.error((Object)("EAICallBackMatcherV2 watch service fail serviceName:" + serviceName), (Throwable)e);
        }
    }

    @Override
    public boolean canApply(HttpUriRequest request) {
        if (StringUtils.isEmpty((Object)this.eaiCallbackPath)) {
            return false;
        }
        Header callbackHeader = request.getFirstHeader("digi-callback-callback");
        return null != callbackHeader && StringUtils.hasText((String)callbackHeader.getValue()) && this.antPathMatcher.match(this.eaiCallbackPath, request.getURI().getPath());
    }

    @Override
    public String getCacheKey(HttpUriRequest request) {
        Header callbackHeader = request.getLastHeader("digi-callback-callback");
        return callbackHeader.getValue();
    }

    @Override
    public boolean match(Map<String, String> instanceMetadata, HttpUriRequest request, boolean vesionAble) {
        String key;
        String targetEaicallbackId = this.getcallbackIdInRequest(request);
        int index = 0;
        while (instanceMetadata.containsKey(key = String.format("dwapi.%d", index))) {
            String api = instanceMetadata.get(key);
            String[] apiSplits = api.split("\\|");
            if (apiSplits.length != 2) {
                ++index;
                continue;
            }
            int tag = Integer.parseInt(apiSplits[1]);
            if (0 == (tag & 8) || this.isVersionAble(new int[]{tag}) ^ vesionAble) {
                ++index;
                continue;
            }
            if (targetEaicallbackId.equals(apiSplits[0])) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String getcallbackIdInRequest(HttpUriRequest request) {
        Header callbackHeader = request.getLastHeader("digi-callback-callback");
        return callbackHeader.getValue();
    }
}

