/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan;

import com.digiwin.loadbalance.scan.DWPathScan;
import com.digiwin.loadbalance.scan.candidate.ControllerApiCandidate;
import com.digiwin.loadbalance.scan.candidate.v2.ControllerApiCandidateV2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.util.CollectionUtils;

public class DWImportSelector
implements ImportSelector,
EnvironmentAware {
    private static final String SCAN_PATHS_PROPERTY_SOURCE_NAME = "digiwin.service.path.version.scan.property";
    public static final String SCAN_PATHS_KEY = "digiwin.service.path.version.scan.packages";
    private Environment environment;

    public String[] selectImports(AnnotationMetadata annotationMetadata) {
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(DWPathScan.class.getName()));
        String[] basePackages = annoAttrs.getStringArray("basePackage");
        if (basePackages.length == 0 && StandardAnnotationMetadata.class.isInstance(annotationMetadata)) {
            basePackages = new String[]{((StandardAnnotationMetadata)annotationMetadata).getIntrospectedClass().getPackage().getName()};
        }
        if (ConfigurableEnvironment.class.isInstance(this.getEnvironment())) {
            ConfigurableEnvironment configEnv = (ConfigurableEnvironment)this.getEnvironment();
            List prePropertyList = (List)configEnv.getProperty(SCAN_PATHS_KEY, List.class);
            HashSet<String> packageSet = new HashSet<String>();
            if (!CollectionUtils.isEmpty((Collection)prePropertyList)) {
                prePropertyList.stream().forEach(o -> packageSet.add(o.toString()));
            }
            LinkedHashMap propertyMap = new LinkedHashMap();
            ArrayList<String> packageList = new ArrayList<String>();
            for (String basePackage : basePackages) {
                packageSet.add(basePackage);
            }
            packageList.addAll(packageSet);
            propertyMap.put(SCAN_PATHS_KEY, packageList);
            MapPropertySource propertySource = new MapPropertySource(SCAN_PATHS_PROPERTY_SOURCE_NAME, propertyMap);
            configEnv.getPropertySources().addFirst((PropertySource)propertySource);
        }
        return new String[]{ControllerApiCandidate.class.getName(), ControllerApiCandidateV2.class.getName()};
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

