/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.esp;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapper;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapperFactory;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.esp.ESPExecutorPoolProperties;
import com.digiwin.loadbalance.exception.io.DWServiceNotFoundIOException;
import com.digiwin.loadbalance.multiple.namespace.DWMultipleLoadBalancerClientFactory;
import com.digiwin.loadbalance.multiple.util.MutipleAppUtil;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.digiwin.loadbalance.watch.ServiceMetadataReactor;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class ESPLoadBalanceUtil {
    private static Log log = LogFactory.getLog(ESPLoadBalanceUtil.class);
    public static final String EAI_SEARCH_URL = "/search/searchEaiServiceName";
    public static final String EAI_ID_SERACH_KEY = "eaiId";
    public static final String EAI_ID_SERACH_SERVICE_NAME_KEY = "onlyServiceName";
    private static DiscoveryClient discoveryClient;
    private static boolean loadBalanceEnable;
    private static int eaiHostRetryInterval;
    private static int eaiHostRetryTimes;
    private static HttpRoutePlanner dwRoutePlanner;
    private static NacosServerListWatcher nacosServerListWatcher;
    private static NacosDiscoveryProperties discoveryProperties;
    private static String eaiRestfulPath;
    private static String eaiCallbackPath;
    private static ESPExecutorPoolProperties espExecutorPoolProperties;
    private static NamingHttpClientProxy namingHttpClientProxy;
    private static DWDiscoveryProperties dwDiscoveryProperties;
    private static TenantIdService tenantIdService;
    private static ServiceMetadataReactor serviceMetadataReactor;
    private static boolean cacheUnregisteredService;
    public static boolean cacheAnonymous;
    private static HttpRoutePlanner dwRerouteRoutePlanner;
    public static DWMainExecWrapper dwMainExecWrapper;
    public static DWMainExecWrapperFactory dwMainExecWrapperFactory;
    private static boolean multiple;
    private static DWMultipleLoadBalancerClientFactory multipleLoadBalancerClientFactory;

    public static boolean isMultiple() {
        return multiple;
    }

    public static void setMultiple(boolean multiple) {
        ESPLoadBalanceUtil.multiple = multiple;
    }

    private static DWMultipleLoadBalancerClientFactory getMultipleLoadBalancerClientFactory() {
        return multipleLoadBalancerClientFactory;
    }

    public static void setMultipleLoadBalancerClientFactory(DWMultipleLoadBalancerClientFactory multipleLoadBalancerClientFactory) {
        ESPLoadBalanceUtil.multipleLoadBalancerClientFactory = multipleLoadBalancerClientFactory;
    }

    public static NacosServerListWatcher getNacosServerListWatcher() {
        return ESPLoadBalanceUtil.isMultiple() ? (NacosServerListWatcher)ESPLoadBalanceUtil.getMultipleLoadBalancerClientFactory().getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), NacosServerListWatcher.class) : nacosServerListWatcher;
    }

    public static NacosDiscoveryProperties getDiscoveryProperties() {
        return ESPLoadBalanceUtil.isMultiple() ? (NacosDiscoveryProperties)ESPLoadBalanceUtil.getMultipleLoadBalancerClientFactory().getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), NacosDiscoveryProperties.class) : discoveryProperties;
    }

    public static DWDiscoveryProperties getDwDiscoveryProperties() {
        return ESPLoadBalanceUtil.isMultiple() ? (DWDiscoveryProperties)ESPLoadBalanceUtil.getMultipleLoadBalancerClientFactory().getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), DWDiscoveryProperties.class) : dwDiscoveryProperties;
    }

    protected static NamingHttpClientProxy getNamingHttpClientProxy() {
        return ESPLoadBalanceUtil.isMultiple() ? (NamingHttpClientProxy)ESPLoadBalanceUtil.getMultipleLoadBalancerClientFactory().getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), NamingHttpClientProxy.class) : namingHttpClientProxy;
    }

    public static void setNamingHttpClientProxy(NamingHttpClientProxy namingHttpClientProxy) {
        ESPLoadBalanceUtil.namingHttpClientProxy = namingHttpClientProxy;
    }

    public static DWMainExecWrapperFactory getDwMainExecWrapperFactory() {
        return dwMainExecWrapperFactory;
    }

    public static void setDwMainExecWrapperFactory(DWMainExecWrapperFactory dwMainExecWrapperFactory) {
        ESPLoadBalanceUtil.dwMainExecWrapperFactory = dwMainExecWrapperFactory;
    }

    public static DiscoveryClient getDiscoveryClient() {
        return ESPLoadBalanceUtil.isMultiple() ? (DiscoveryClient)ESPLoadBalanceUtil.getMultipleLoadBalancerClientFactory().getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), DiscoveryClient.class) : discoveryClient;
    }

    public static void setDiscoveryClient(DiscoveryClient discoveryClient) {
        ESPLoadBalanceUtil.discoveryClient = discoveryClient;
    }

    public static boolean getloadBalanceEnable() {
        return loadBalanceEnable;
    }

    public static void setLoadBalanceEnable(boolean loadBalanceEnable) {
        ESPLoadBalanceUtil.loadBalanceEnable = loadBalanceEnable;
    }

    public static int getEaiHostRetryInterval() {
        return eaiHostRetryInterval;
    }

    public static void setEaiHostRetryInterval(int eaiHostRetryInterval) {
        ESPLoadBalanceUtil.eaiHostRetryInterval = eaiHostRetryInterval;
    }

    public static int getEaiHostRetryTimes() {
        return eaiHostRetryTimes;
    }

    public static void setEaiHostRetryTimes(int eaiHostRetryTimes) {
        ESPLoadBalanceUtil.eaiHostRetryTimes = eaiHostRetryTimes;
    }

    public static HttpRoutePlanner getDwRoutePlanner() {
        return dwRoutePlanner;
    }

    public static void setDwRoutePlanner(HttpRoutePlanner dwRoutePlanner) {
        ESPLoadBalanceUtil.dwRoutePlanner = dwRoutePlanner;
    }

    public static void setNacosServerListWatcher(NacosServerListWatcher nacosServerListWatcher) {
        ESPLoadBalanceUtil.nacosServerListWatcher = nacosServerListWatcher;
    }

    public static void setDiscoveryProperties(NacosDiscoveryProperties discoveryProperties) {
        ESPLoadBalanceUtil.discoveryProperties = discoveryProperties;
    }

    public static String getEaiRestfulPath() {
        return eaiRestfulPath;
    }

    public static void setEaiRestfulPath(String eaiRestfulPath) {
        ESPLoadBalanceUtil.eaiRestfulPath = eaiRestfulPath;
    }

    public static String getEaiCallbackPath() {
        return eaiCallbackPath;
    }

    public static void setEaiCallbackPath(String eaiCallbackPath) {
        ESPLoadBalanceUtil.eaiCallbackPath = eaiCallbackPath;
    }

    public static ESPExecutorPoolProperties getEspExecutorPoolProperties() {
        return espExecutorPoolProperties;
    }

    public static void setEspExecutorPoolProperties(ESPExecutorPoolProperties espExecutorPoolProperties) {
        ESPLoadBalanceUtil.espExecutorPoolProperties = espExecutorPoolProperties;
    }

    public static void setDwDiscoveryProperties(DWDiscoveryProperties dwDiscoveryProperties) {
        ESPLoadBalanceUtil.dwDiscoveryProperties = dwDiscoveryProperties;
    }

    public static boolean isLoadBalanceEnable() {
        return loadBalanceEnable;
    }

    public static TenantIdService getTenantIdService() {
        return tenantIdService;
    }

    public static void setTenantIdService(TenantIdService tenantIdService) {
        ESPLoadBalanceUtil.tenantIdService = tenantIdService;
    }

    public static ServiceMetadataReactor getServiceMetadataReactor() {
        return ESPLoadBalanceUtil.isMultiple() ? (ServiceMetadataReactor)ESPLoadBalanceUtil.getMultipleLoadBalancerClientFactory().getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), ServiceMetadataReactor.class) : serviceMetadataReactor;
    }

    public static void setServiceMetadataReactor(ServiceMetadataReactor serviceMetadataReactor) {
        ESPLoadBalanceUtil.serviceMetadataReactor = serviceMetadataReactor;
    }

    public static String getESPRequestTenantId(Map<String, Object> headers) throws Exception {
        return ESPLoadBalanceUtil.getTenantId(headers);
    }

    private static String getPriorityRequestHeader(Map<String, Object> headers, List<String> names) {
        for (String name : names) {
            String header;
            Object headerObject = headers.getOrDefault(name, "");
            if (null == headerObject || !StringUtils.isNotBlank((CharSequence)(header = headerObject.toString()))) continue;
            return header;
        }
        return null;
    }

    private static String getRouteKey(Map<String, Object> headers) {
        return ESPLoadBalanceUtil.getPriorityRequestHeader(headers, ESPLoadBalanceUtil.getDwDiscoveryProperties().getRouteKeyNamesList());
    }

    private static String getToken(Map<String, Object> headers) {
        return ESPLoadBalanceUtil.getPriorityRequestHeader(headers, ESPLoadBalanceUtil.getDwDiscoveryProperties().getTokenNamesList());
    }

    private static String getTenantId(Map<String, Object> headers) throws Exception {
        String tenantId = null;
        tenantId = ESPLoadBalanceUtil.getRouteKey(headers);
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            log.debug((Object)("esp request routeKey:" + tenantId));
            return tenantId;
        }
        String token = ESPLoadBalanceUtil.getToken(headers);
        log.debug((Object)("esp request token:" + token));
        tenantId = ESPLoadBalanceUtil.getTenantIdService().getTenantId(token);
        return tenantId;
    }

    public static boolean isCacheUnregisteredService() {
        return cacheUnregisteredService;
    }

    public static void setCacheUnregisteredService(boolean cacheUnregisteredService) {
        ESPLoadBalanceUtil.cacheUnregisteredService = cacheUnregisteredService;
    }

    public static boolean isCacheAnonymous() {
        return cacheAnonymous;
    }

    public static void setCacheAnonymous(boolean cacheAnonymous) {
        ESPLoadBalanceUtil.cacheAnonymous = cacheAnonymous;
    }

    public static DWMainExecWrapper getDwMainExecWrapper() {
        return dwMainExecWrapperFactory == null ? null : dwMainExecWrapperFactory.getWrapper(true);
    }

    public static boolean retryServiceNoFound(Exception exception) {
        return exception instanceof DWServiceNotFoundIOException;
    }

    public static HttpRoutePlanner getDwRerouteRoutePlanner() {
        return dwRerouteRoutePlanner;
    }

    public static void setDwRerouteRoutePlanner(HttpRoutePlanner dwRerouteRoutePlanner) {
        ESPLoadBalanceUtil.dwRerouteRoutePlanner = dwRerouteRoutePlanner;
    }

    static {
        cacheUnregisteredService = true;
        cacheAnonymous = true;
        multiple = false;
    }
}

