/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.watch;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.digiwin.loadbalance.discovery.DWDiscoveryEventCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NacosServerListWatcher {
    private static Log log = LogFactory.getLog(NacosServerListWatcher.class);
    NacosServiceManager nacosServiceManager;
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public NacosServerListWatcher(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosServiceManager = nacosServiceManager;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    public void watch(String serviceName, DWDiscoveryEventCallback eventCallback) throws NacosException {
        try {
            log.info((Object)("watch app:" + serviceName + ",nacosDiscoveryProperties:" + this.nacosDiscoveryProperties));
            this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties()).subscribe(serviceName, this.nacosDiscoveryProperties.getGroup(), event -> {
                if (event instanceof NamingEvent) {
                    eventCallback.run(event);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)("fail to subscribe serviceInstances serviceName:" + serviceName), (Throwable)e);
            throw e;
        }
    }
}

