/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.watch;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.NoneSelector;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.dto.SearchServiceResultDto;
import com.digiwin.loadbalance.esp.ESPServerNameCacheUtil;
import com.digiwin.loadbalance.event.ServiceNotExistEvent;
import com.digiwin.loadbalance.scan.metadata.compress.DWAPiMetadata;
import com.digiwin.loadbalance.task.service.ServiceMetadataTaskKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.CollectionUtils;

public class ServiceMetadataReactor
implements ApplicationEventPublisherAware,
DisposableBean {
    private Log log = LogFactory.getLog(ServiceMetadataReactor.class);
    public static final int DEFAULT_SERVICE_POLLING_THREAD_COUNT = Runtime.getRuntime().availableProcessors() > 1 ? Runtime.getRuntime().availableProcessors() : 1;
    private final ScheduledExecutorService executor;
    ApplicationEventPublisher applicationEventPublisher;
    NamingHttpClientProxy httpClientProxy;
    DWDiscoveryProperties dwDiscoveryProperties;
    private ConcurrentHashMap<ServiceMetadataTaskKey, ServiceMetadataTaskKey> serviceMetadataPollingMap = new ConcurrentHashMap();

    public ServiceMetadataReactor(DWDiscoveryProperties dwDiscoveryProperties, NamingHttpClientProxy httpClientProxy) {
        this.dwDiscoveryProperties = dwDiscoveryProperties;
        this.httpClientProxy = httpClientProxy;
        this.executor = new ScheduledThreadPoolExecutor(DEFAULT_SERVICE_POLLING_THREAD_COUNT, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("com.digiwin.loadbalance.client.service.checker");
            return thread;
        });
    }

    public void addServiceMetadataTask(String appId) {
        ServiceMetadataTaskKey serviceMetadataTaskKey = new ServiceMetadataTaskKey(this.dwDiscoveryProperties.getNamespace(), this.dwDiscoveryProperties.getGroup(), this.dwDiscoveryProperties.getClusterName(), appId, true);
        this.serviceMetadataPollingMap.computeIfAbsent(serviceMetadataTaskKey, key -> {
            this.executor.schedule(new ServiceMetadaExecuTask((ServiceMetadataTaskKey)key), TimeUnit.SECONDS.toMillis(60L), TimeUnit.MILLISECONDS);
            return key;
        });
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public boolean checkServiceExist(String serviceName) {
        List collect;
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("namespaceId", this.dwDiscoveryProperties.getNamespace());
        params.put("groupName", this.dwDiscoveryProperties.getGroup());
        params.put("expr", serviceName);
        params.put("responsibleOnly", "true");
        String serviceSearch = null;
        try {
            serviceSearch = this.httpClientProxy.reqApi(UtilAndComs.nacosUrlService + "/names", params, "GET");
        }
        catch (NacosException e) {
            this.log.error((Object)("search service namespace:" + this.dwDiscoveryProperties.getNamespace() + "group:" + this.dwDiscoveryProperties.getGroup() + "service:" + serviceName + "error:"), (Throwable)e);
        }
        if (null == serviceSearch) {
            return true;
        }
        SearchServiceResultDto searchServiceResultDto = (SearchServiceResultDto)DWGsonProvider.getGson().fromJson(serviceSearch, SearchServiceResultDto.class);
        Map<String, String[]> serviceMap = searchServiceResultDto.getServices();
        if (null == serviceMap) {
            return false;
        }
        String[] nameSpaceServiceArray = serviceMap.get(this.httpClientProxy.getNamespaceId());
        return nameSpaceServiceArray != null && (collect = Arrays.stream(nameSpaceServiceArray).filter(groupServiceName -> {
            String[] groupServiceStr = groupServiceName.split("@@");
            if (groupServiceStr.length == 2) {
                return groupServiceStr[0].equals(this.dwDiscoveryProperties.getGroup()) && groupServiceStr[1].equals(serviceName);
            }
            return false;
        }).collect(Collectors.toList())).size() == 1;
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
    }

    class ServiceMetadaExecuTask
    implements Runnable {
        ServiceMetadataTaskKey serviceMetadataTaskKey;
        private String name;

        public ServiceMetadaExecuTask(ServiceMetadataTaskKey serviceMetadataTaskKey) {
            if (Objects.isNull(serviceMetadataTaskKey)) {
                throw new IllegalArgumentException("serviceMetadataTaskKey must not be null");
            }
            this.serviceMetadataTaskKey = serviceMetadataTaskKey;
            this.name = serviceMetadataTaskKey.getServiceName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean needStop = false;
            try {
                Service remoteService = ServiceMetadataReactor.this.httpClientProxy.queryService(this.name, ServiceMetadataReactor.this.dwDiscoveryProperties.getGroup());
                Map remoteServiceMetadata = remoteService.getMetadata();
                if (this.name.equals(ServiceMetadataReactor.this.dwDiscoveryProperties.getRegisterName())) {
                    Set<DWAPiMetadata> eaiSetV2 = ServiceMetadataReactor.this.dwDiscoveryProperties.getEaiSetV2();
                    boolean metadataChanged = false;
                    for (DWAPiMetadata eaiApi : eaiSetV2) {
                        if (remoteServiceMetadata.containsKey(eaiApi.getAPIid())) continue;
                        metadataChanged = true;
                        break;
                    }
                    if (metadataChanged) {
                        eaiSetV2.stream().forEach(eaiMetadata -> remoteServiceMetadata.putIfAbsent(eaiMetadata.getAPIid(), eaiMetadata.getAPIid()));
                        remoteService.setMetadata(remoteServiceMetadata);
                        ServiceMetadataReactor.this.httpClientProxy.updateService(remoteService, (AbstractSelector)new NoneSelector());
                    }
                }
                ConcurrentMap eaiSnapshotMap = ESPServerNameCacheUtil.eaiIdCache.asMap();
                eaiSnapshotMap.forEach((k, list) -> {
                    if (!CollectionUtils.isEmpty((Collection)list) && list.contains(this.name) && !remoteServiceMetadata.containsKey(k)) {
                        eaiSnapshotMap.remove(k);
                    }
                });
                remoteServiceMetadata.forEach((k, v) -> {
                    String unCachekeyWithEmptyName;
                    String unCachekey = ESPServerNameCacheUtil.getUnCachekey(this.name, k);
                    if (null != ESPServerNameCacheUtil.unregistedCache.getIfPresent((Object)unCachekey)) {
                        ESPServerNameCacheUtil.unregistedCache.invalidate((Object)unCachekey);
                    }
                    if (null != ESPServerNameCacheUtil.unregistedCache.getIfPresent((Object)(unCachekeyWithEmptyName = ESPServerNameCacheUtil.getUnCachekey("", k)))) {
                        ESPServerNameCacheUtil.unregistedCache.invalidate((Object)unCachekeyWithEmptyName);
                    }
                });
            }
            catch (Exception e) {
                ServiceMetadataReactor.this.log.error((Object)"dap pull service metadata fail , does not affect business ", (Throwable)e);
                if (e instanceof NacosException && (((NacosException)e).getErrCode() == 404 || ((NacosException)e).getErrCode() == 500)) {
                    needStop = true;
                    ServiceMetadataReactor.this.log.info((Object)("serice :" + this.name + " not exist stop pull"));
                    ServiceMetadataReactor.this.serviceMetadataPollingMap.remove(this.serviceMetadataTaskKey);
                    ServiceMetadataReactor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new ServiceNotExistEvent(this, this.name));
                }
            }
            finally {
                if (!needStop) {
                    ServiceMetadataReactor.this.executor.schedule(this, TimeUnit.MINUTES.toMillis(3L), TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

