/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Order(value=2147482647)
public class EAICallBackMatcher
implements DWMatcher {
    private static Log log = LogFactory.getLog(EAICallBackMatcher.class);
    private static final String EAIPATH_PATTERN_CALLBACK = "/eai/**/callback";
    AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String eaiCallbackPath = null;
    NacosServerListWatcher nacosServerListWatcher;
    Environment environment;
    DiscoveryClient discoveryClient;

    public EAICallBackMatcher(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        this.nacosServerListWatcher = nacosServerListWatcher;
        this.environment = environment;
        this.discoveryClient = discoveryClient;
        String serviceName = environment.getProperty("loadbalancer.client.name");
        List instances = discoveryClient.getInstances(serviceName);
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            String eaiRestfulCallbackPath;
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
            this.eaiCallbackPath = eaiRestfulCallbackPath = (String)serviceInstance.getMetadata().get("eai.callbackPath");
        }
        try {
            nacosServerListWatcher.watch(serviceName, event -> {
                List nameInstances;
                if (event instanceof NamingEvent && !CollectionUtils.isEmpty((Collection)(nameInstances = ((NamingEvent)event).getInstances()))) {
                    String eaiRestfulCallbackPath;
                    Instance instance = (Instance)nameInstances.get(0);
                    this.eaiCallbackPath = eaiRestfulCallbackPath = (String)instance.getMetadata().get("eai.callbackPath");
                }
            });
        }
        catch (NacosException e) {
            log.error((Object)("EAICallBackMatcherV2 watch service fail serviceName:" + serviceName), (Throwable)e);
        }
    }

    private boolean pathMatche(String pattern, String path) {
        return this.antPathMatcher.match(pattern, path);
    }

    @Override
    public String prefix() {
        return "EAI";
    }

    @Override
    public boolean canApply(HttpUriRequest request) {
        if (StringUtils.isEmpty((Object)this.eaiCallbackPath)) {
            return false;
        }
        Header callbackHeader = request.getFirstHeader("digi-callback-callback");
        return null != callbackHeader && StringUtils.hasText((String)callbackHeader.getValue()) && this.pathMatche(this.eaiCallbackPath, request.getURI().getPath());
    }

    @Override
    public String getCacheKey(HttpUriRequest request) {
        Header callbackHeader = request.getLastHeader("digi-callback-callback");
        return callbackHeader.getValue();
    }

    @Override
    public boolean match(String pattern, HttpUriRequest request) {
        String apiId = this.prefix() + "|" + this.getCacheKey(request);
        return apiId.equals(pattern);
    }
}

