/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.multiple.module.listener;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.digiwin.loadbalance.multiple.metadata.GroupedMetadata;
import com.digiwin.loadbalance.multiple.namespace.DWMultipleLoadBalancerClientFactory;
import com.digiwin.loadbalance.multiple.util.MutipleAppUtil;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import com.digiwin.loadbalance.scan.v2.DWCommonScannerV2;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class MultipleAppInitializedListener
implements ApplicationListener<WebServerInitializedEvent>,
ApplicationEventPublisherAware {
    DWMultipleLoadBalancerClientFactory dwMultipleLoadBalancerClientFactory;
    DWResourceHelper dwResourceHelper;
    Environment environment;
    DWCommonScanner dwCommonScanner;
    DWCommonScannerV2 dwCommonScannerV2;
    ApplicationEventPublisher applicationEventPublisher;
    public static final String MULTIPLE_APP_METADATA_NAMESPACE = "multiple.app.metadata.namespace";
    public static final String MULTIPLE_APP_METADATA_NAME = "multiple.app.metadata.app.";

    public MultipleAppInitializedListener(DWMultipleLoadBalancerClientFactory dwMultipleLoadBalancerClientFactory, DWResourceHelper dwResourceHelper, Environment environment, DWCommonScanner dwCommonScanner, DWCommonScannerV2 dwCommonScannerV2) {
        this.dwMultipleLoadBalancerClientFactory = dwMultipleLoadBalancerClientFactory;
        this.dwResourceHelper = dwResourceHelper;
        this.environment = environment;
        this.dwCommonScanner = dwCommonScanner;
        this.dwCommonScannerV2 = dwCommonScannerV2;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        List<DWTargetResource> dwTargetResource = this.dwResourceHelper.getDWTargetResource(this.environment);
        Map<String, List<DWTargetResource>> groupedResources = dwTargetResource.stream().collect(Collectors.groupingBy(r -> MutipleAppUtil.getAppName(r.getPrefix())));
        for (Map.Entry<String, List<DWTargetResource>> entry : groupedResources.entrySet()) {
            GroupedMetadata groupedMetadata = new GroupedMetadata();
            try {
                groupedMetadata.setApiSet(this.dwCommonScanner.scan(entry.getValue()));
                groupedMetadata.setApiSetV2(this.dwCommonScannerV2.scan(entry.getValue()));
                groupedMetadata.setGroup(entry.getKey());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.environment instanceof ConfigurableEnvironment) {
                ((ConfigurableEnvironment)this.environment).getPropertySources().addLast((PropertySource)new MapPropertySource("multiple.app.metadata.namespace." + entry.getKey(), Collections.singletonMap("multiple.app.metadata.app.." + entry.getKey(), groupedMetadata)));
            }
            NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)this.dwMultipleLoadBalancerClientFactory.getInstance(entry.getKey(), NacosDiscoveryProperties.class);
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)this, null));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

