/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.scan.candidate;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.loadbalance.scan.DWVersionable;
import com.digiwin.loadbalance.scan.candidate.AbstractVersionApiCandidate;
import com.digiwin.loadbalance.scan.metadata.ApiMetadata;
import com.digiwin.loadbalance.scan.metadata.CommonApiMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;

public class DWStandardApiCandidate
extends AbstractVersionApiCandidate {
    private static Log log = LogFactory.getLog(DWStandardApiCandidate.class);
    private static String REQUEST_PATH_PREFIX = "/restful/standard/";

    @Override
    public List<ApiMetadata> resolverPathRegex(MetadataReader metadataReader, String rootPath) {
        ArrayList<ApiMetadata> apiMetadataList = new ArrayList<ApiMetadata>();
        if (metadataReader.getClassMetadata().isInterface() && metadataReader.getAnnotationMetadata().hasAnnotation(DWRestfulService.class.getName()) && Arrays.stream(metadataReader.getClassMetadata().getInterfaceNames()).filter(interfaceName -> DWService.class.getName().equals(interfaceName)).findAny().isPresent()) {
            String classRequestPath = "";
            if (metadataReader.getAnnotationMetadata().hasAnnotation(DWRequestMapping.class.getName())) {
                Map classrequestMappingAttributes = metadataReader.getAnnotationMetadata().getAnnotationAttributes(DWRequestMapping.class.getName());
                classRequestPath = classrequestMappingAttributes.get("path").toString();
            }
            boolean classVersionPathFlag = false;
            if (metadataReader.getAnnotationMetadata().hasAnnotation(DWVersionable.class.getName())) {
                classVersionPathFlag = true;
            }
            Set annotatedMethods = metadataReader.getAnnotationMetadata().getAnnotatedMethods(DWRequestMapping.class.getName());
            for (MethodMetadata methodMetadata : annotatedMethods) {
                if (classVersionPathFlag) {
                    apiMetadataList.add(new CommonApiMetadata(REQUEST_PATH_PREFIX + rootPath + "/" + classRequestPath + "/" + String.valueOf(methodMetadata.getAnnotationAttributes(DWRequestMapping.class.getName()).get("path")), true));
                    continue;
                }
                apiMetadataList.add(new CommonApiMetadata(REQUEST_PATH_PREFIX + rootPath + "/" + classRequestPath + "/" + String.valueOf(methodMetadata.getAnnotationAttributes(DWRequestMapping.class.getName()).get("path")), methodMetadata.isAnnotated(DWVersionable.class.getName())));
            }
        }
        return apiMetadataList;
    }
}

