/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.dap.component.loadbalance.api.LoadbalanceConfigProvider;
import com.digiwin.loadbalance.esp.DWEAIPropertiesBean;
import com.digiwin.loadbalance.esp.ServiceMetadataListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
@DependsOn(value={"loadbalanceClassLoaderProvider", "loadbalanceConfigProvider", "loadbalanceGroupTargetResourceProvider", "loadbalanceModuleTargetResourceProvider", "loadbalanceSourceAppAwareProvider", "dw-spring-context-utils", "dw-json-config"})
public class ESPPropertiesAutoConfiguration {
    private Log log = LogFactory.getLog(ESPPropertiesAutoConfiguration.class);

    @Bean
    DWEAIPropertiesBean dweaiPropertiesBean(Environment env, LoadbalanceConfigProvider loadbalanceConfigProvider) {
        String customId;
        DWEAIPropertiesBean dweaiPropertiesBean = new DWEAIPropertiesBean();
        String customBasePath = env.getProperty("eaiRestfulUrl");
        if (customBasePath != null) {
            customBasePath = customBasePath.trim();
        }
        if ("@eaiRestfulUrl@".equals(customBasePath)) {
            customBasePath = null;
        }
        if (customBasePath == null || customBasePath.length() == 0) {
            customBasePath = loadbalanceConfigProvider.getEaiDefaultBasePath();
        }
        if ((customId = env.getProperty("eaiRestfulCustomId")) != null) {
            customId = customId.trim();
        }
        if ("@eaiRestfulCustomId@".equals(customId)) {
            customId = null;
        }
        String eaiPath = null;
        String eaiCallbackPath = null;
        if (customId != null && customId.length() > 0) {
            eaiPath = customBasePath + "/" + customId;
            eaiCallbackPath = customBasePath + "/" + customId + "/callback";
        } else {
            eaiPath = customBasePath;
            eaiCallbackPath = customBasePath + "/callback";
        }
        dweaiPropertiesBean.setHostRetryTimes(env.getProperty("eaiHostRetrytimes", ""));
        dweaiPropertiesBean.setHostRetryInterval(env.getProperty("eaiHostRetryinterval", ""));
        dweaiPropertiesBean.setRestfulServicePath(eaiPath);
        dweaiPropertiesBean.setRestfulServiceCallbackPath(eaiCallbackPath);
        return dweaiPropertiesBean;
    }

    @Bean
    public ServiceMetadataListener serviceMetadataListener() {
        return new ServiceMetadataListener();
    }
}

