/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.autoconfigure;

import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.loadbalance.condition.ConditionalOnDWAPi;
import com.digiwin.loadbalance.scan.DWCommonScanner;
import com.digiwin.loadbalance.scan.candidate.DWEAIApiCandidate;
import com.digiwin.loadbalance.scan.candidate.DWResourceHelper;
import com.digiwin.loadbalance.scan.candidate.DWRestfulApiCandidate;
import com.digiwin.loadbalance.scan.candidate.DWStandardApiCandidate;
import com.digiwin.loadbalance.scan.candidate.VersionApiCandidate;
import com.digiwin.loadbalance.scan.candidate.v2.DWApiCandidate;
import com.digiwin.loadbalance.scan.candidate.v2.DWEAIApiCandidateV2;
import com.digiwin.loadbalance.scan.candidate.v2.DWEAICallbackApiCandidateV2;
import com.digiwin.loadbalance.scan.candidate.v2.DWRestfulApiCandidateV2;
import com.digiwin.loadbalance.scan.candidate.v2.DWStandardApiCandidateV2;
import com.digiwin.loadbalance.scan.v2.DWCommonScannerV2;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"digiwin.load.balance.autoCongiguration.flage"}, matchIfMissing=false)
@DependsOn(value={"dw-spring-context-utils"})
public class DWLoadBalancerScanningAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"dwloadbalance.support.api.non-compressed"})
    @ConditionalOnDWAPi(value="DWRESTFULSERVICE")
    DWRestfulApiCandidate dwRestfulApiCandidate() {
        return new DWRestfulApiCandidate();
    }

    @Bean
    @ConditionalOnDWAPi(value="DWRESTFULSERVICE")
    DWRestfulApiCandidateV2 dwRestfulApiCandidateV2() {
        return new DWRestfulApiCandidateV2();
    }

    @Bean
    @ConditionalOnClass(value={DWRestfulService.class})
    @ConditionalOnProperty(name={"dwloadbalance.support.api.non-compressed"})
    @ConditionalOnDWAPi(value="DWRESTFULSTANDERD")
    DWStandardApiCandidate dwStandardApiCandidate() {
        return new DWStandardApiCandidate();
    }

    @Bean
    @ConditionalOnClass(value={DWRestfulService.class})
    @ConditionalOnDWAPi(value="DWRESTFULSTANDERD")
    DWStandardApiCandidateV2 dwStandardApiCandidateV2() {
        return new DWStandardApiCandidateV2();
    }

    @Bean
    @ConditionalOnClass(name={"com.digiwin.app.service.eai.EAIService", "com.digiwin.app.service.eai.EAICallback"})
    @ConditionalOnExpression(value="${esp.register.enable:true} && ${dwloadbalance.support.api.non-compressed:false}")
    @ConditionalOnDWAPi(value="EAI")
    DWEAIApiCandidate dweaiApiCandidate() {
        return new DWEAIApiCandidate();
    }

    @Bean
    @ConditionalOnClass(name={"com.digiwin.app.service.eai.EAIService", "com.digiwin.app.service.eai.EAICallback"})
    @ConditionalOnProperty(value={"esp.register.enable"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnDWAPi(value="EAI")
    DWEAIApiCandidateV2 dweaiApiCandidateV2() {
        return new DWEAIApiCandidateV2();
    }

    @Bean
    @ConditionalOnClass(name={"com.digiwin.app.service.eai.EAIService", "com.digiwin.app.service.eai.EAICallback"})
    @ConditionalOnProperty(value={"esp.register.enable"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnDWAPi(value="EAI")
    DWEAICallbackApiCandidateV2 dweaiCallbackApiCandidateV2() {
        return new DWEAICallbackApiCandidateV2();
    }

    @Bean
    DWCommonScanner dwCommonScanner(Environment environment, ObjectProvider<List<VersionApiCandidate>> apiCandidatesProvider, DWResourceHelper dwResourceHelper) {
        List apiCandidates = (List)apiCandidatesProvider.getIfAvailable();
        return new DWCommonScanner(environment, apiCandidates, dwResourceHelper);
    }

    @Bean
    DWCommonScannerV2 dwCommonScannerV2(ObjectProvider<List<DWApiCandidate>> apiCandidatesProvider) {
        List apiCandidates = (List)apiCandidatesProvider.getIfAvailable();
        return new DWCommonScannerV2(apiCandidates);
    }
}

