/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.config;

import com.alibaba.nacos.api.exception.NacosException;
import com.digiwin.loadbalance.client.config.DWDefaultTenantServiceConfig;
import com.digiwin.loadbalance.client.config.TenantServiceConfig;
import com.digiwin.loadbalance.loadbalancer.DWClientTenantRoundLoadBalancer;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.EAICallBackMatcher;
import com.digiwin.loadbalance.matcher.EAIMatcher;
import com.digiwin.loadbalance.matcher.delegate.DWMatcherDelegate;
import com.digiwin.loadbalance.matcher.delegate.EAICallBackMatcherDelegate;
import com.digiwin.loadbalance.matcher.delegate.EAIMatcherDelegate;
import com.digiwin.loadbalance.matcher.v2.EAICallBackMatcherV2;
import com.digiwin.loadbalance.matcher.v2.EAIMatcherV2;
import com.digiwin.loadbalance.region.DefaultRegionSwitch;
import com.digiwin.loadbalance.region.RegionSwitch;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.Environment;

@Configuration
@DependsOn(value={"loadbalanceClassLoaderProvider", "loadbalanceConfigProvider", "loadbalanceGroupTargetResourceProvider", "loadbalanceModuleTargetResourceProvider", "loadbalanceSourceAppAwareProvider", "dw-spring-context-utils", "dw-json-config"})
public class DWClientLoadBlanceConfigure {
    @Bean
    TenantServiceConfig defaultTenantServiceConfig(Environment environment) {
        String serviceName = environment.getProperty("loadbalancer.client.name");
        return new DWDefaultTenantServiceConfig(serviceName);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceInstanceChooser reactorServiceInstanceLoadBalancer(Environment environment, DiscoveryClient discoveryClient, TenantServiceConfig tenantServiceConfig, NacosServerListWatcher nacosServerListWatcher, RegionSwitch regionSwitch, List<DWMatcherDelegate> matcherDelegates) throws NacosException {
        OrderComparator.sort(matcherDelegates);
        String name = environment.getProperty("loadbalancer.client.name");
        return new DWClientTenantRoundLoadBalancer(discoveryClient, tenantServiceConfig, name, nacosServerListWatcher, regionSwitch, matcherDelegates);
    }

    @Bean
    DWMatcher eaiMatcher(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        return new EAIMatcher(nacosServerListWatcher, environment, discoveryClient);
    }

    @Bean
    EAICallBackMatcher eaiCallBackMatcher(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        return new EAICallBackMatcher(nacosServerListWatcher, environment, discoveryClient);
    }

    @Bean
    RegionSwitch regionSwitch(Environment environment, ApplicationContext applicationContext) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new DefaultRegionSwitch(name, applicationContext);
    }

    @Bean
    EAICallBackMatcherV2 eaiCallBackMatcherV2(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        return new EAICallBackMatcherV2(nacosServerListWatcher, environment, discoveryClient);
    }

    @Bean
    @DependsOn(value={"eaiMatcher", "eaiCallBackMatcherV2"})
    DWMatcherDelegate eaiCallBackMatcherDelegate(EAICallBackMatcherV2 eaiCallBackMatcherV2, EAIMatcher eaiMatcher, EAICallBackMatcher eaiCallBackMatcher) {
        return new EAICallBackMatcherDelegate(eaiCallBackMatcherV2, eaiMatcher, eaiCallBackMatcher);
    }

    @Bean
    EAIMatcherV2 eaiMatcherV2eaiMatcher(NacosServerListWatcher nacosServerListWatcher, Environment environment, DiscoveryClient discoveryClient) {
        return new EAIMatcherV2(nacosServerListWatcher, environment, discoveryClient);
    }

    @Bean
    @DependsOn(value={"eaiMatcher", "eaiMatcherV2eaiMatcher"})
    DWMatcherDelegate eaiMatcherDelegate(EAIMatcher eaiMatcher, EAIMatcherV2 eaiMatcherV2) {
        return new EAIMatcherDelegate(eaiMatcher, eaiMatcherV2);
    }
}

