/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.multiple.config.filter;

import java.util.HashSet;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(value={"dap.multiple-app-env", "digiwin.load.balance.autoCongiguration.flage"})
public class MultipleConfigFilter
implements EnvironmentAware,
AutoConfigurationImportFilter {
    Environment environment;

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        HashSet<String> excludeAutoConfiguration = new HashSet<String>();
        if ("true".equalsIgnoreCase(this.environment.getProperty("dap.multiple-app-env"))) {
            excludeAutoConfiguration.add("org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClientAutoConfiguration");
        }
        boolean[] matches = new boolean[autoConfigurationClasses.length];
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            matches[i] = !excludeAutoConfiguration.contains(autoConfigurationClasses[i]);
        }
        return matches;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

