/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.multiple.module.config;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClient;
import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.cloud.nacos.discovery.NacosWatch;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.digiwin.loadbalance.discovery.DWDiscoveryProperties;
import com.digiwin.loadbalance.multiple.module.config.MultipleNacosAutoServiceRegistration;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.service.DefaultUpdateMetadataService;
import com.digiwin.loadbalance.service.UpdateMetadataService;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
@DependsOn(value={"loadbalanceClassLoaderProvider", "loadbalanceConfigProvider", "loadbalanceGroupTargetResourceProvider", "loadbalanceModuleTargetResourceProvider", "loadbalanceSourceAppAwareProvider", "dw-spring-context-utils", "dw-json-config"})
public class ModuleConfig
implements ApplicationListener,
EnvironmentAware {
    public static final String GROUP_APP_NAME = "spring.application.name";
    public static final String GROUP_PROPERTYSOURCE_NAME = "group.propertySrouce.name";

    @Bean
    @ConditionalOnClass(value={HttpClient.class})
    public DWLoadBalancerClientFactory loadBalancerClientFactory() {
        return new DWLoadBalancerClientFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public NacosDiscoveryProperties nacosProperties() {
        return new NacosDiscoveryProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public NacosServiceDiscovery nacosServiceDiscovery(NacosDiscoveryProperties discoveryProperties, NacosServiceManager nacosServiceManager) {
        return new NacosServiceDiscovery(discoveryProperties, nacosServiceManager);
    }

    @Bean
    @Primary
    public DiscoveryClient nacosDiscoveryClient(NacosServiceDiscovery nacosServiceDiscovery) {
        return new NacosDiscoveryClient(nacosServiceDiscovery);
    }

    @Bean
    @ConditionalOnMissingBean
    public NacosWatch nacosWatch(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosWatch(nacosServiceManager, nacosDiscoveryProperties);
    }

    @Bean
    @Primary
    public UpdateMetadataService updateMetadataService(NacosRegistration nacosRegistration, NacosServiceRegistry nacosServiceRegistry, NacosDiscoveryProperties nacosDiscoveryProperties, NamingHttpClientProxy namingProxy, DWDiscoveryProperties dwDiscoveryProperties) {
        return new DefaultUpdateMetadataService(nacosRegistration, nacosServiceRegistry, nacosDiscoveryProperties, dwDiscoveryProperties, namingProxy);
    }

    @Bean
    public NacosServiceManager nacosServiceManager() {
        return new NacosServiceManager();
    }

    @Bean
    public NacosServiceRegistry nacosServiceRegistry(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosServiceRegistry(nacosServiceManager, nacosDiscoveryProperties);
    }

    @Bean
    public NacosRegistration nacosRegistration(ObjectProvider<List<NacosRegistrationCustomizer>> registrationCustomizers, NacosDiscoveryProperties nacosDiscoveryProperties, ApplicationContext context) {
        return new NacosRegistration((List)registrationCustomizers.getIfAvailable(), nacosDiscoveryProperties, context);
    }

    @Bean
    public MultipleNacosAutoServiceRegistration nacosAutoServiceRegistration(NacosServiceRegistry registry, NacosRegistration registration) {
        return new MultipleNacosAutoServiceRegistration((ServiceRegistry)registry, null, registration);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Environment environment;
        if (!(event instanceof ContextRefreshedEvent) || (environment = ((ContextRefreshedEvent)event).getApplicationContext().getEnvironment()) instanceof ConfigurableEnvironment) {
            // empty if block
        }
    }

    public void setEnvironment(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            String appName = (String)environment.getProperty("loadbalancer.multiple..client.name", String.class);
            HashMap<String, String> envMap = new HashMap<String, String>();
            envMap.put(GROUP_APP_NAME, appName);
            envMap.put("appId", appName);
            ((ConfigurableEnvironment)environment).getPropertySources().addFirst((PropertySource)new MapPropertySource(GROUP_PROPERTYSOURCE_NAME, envMap));
        }
    }
}

