/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher;

import com.digiwin.loadbalance.matcher.DWMatcher;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.core.annotation.Order;
import org.springframework.util.AntPathMatcher;

@Order(value=0x7FFFFFFF)
public class UrlPathMatcher
implements DWMatcher {
    AntPathMatcher pathMatcher = new AntPathMatcher();

    public boolean canApply(HttpUriRequest request) {
        return true;
    }

    public String getCacheKey(HttpUriRequest request) {
        return request.getURI().getPath();
    }

    public boolean match(String pattern, HttpUriRequest request) {
        return this.match(pattern, request.getURI().getPath());
    }

    private boolean match(String pattern, String lookupPath) {
        boolean hasSuffix;
        if (pattern.equals(lookupPath)) {
            return true;
        }
        if (this.pathMatcher.match(pattern, lookupPath)) {
            return true;
        }
        if (!pattern.endsWith("/") && this.pathMatcher.match(pattern + "/", lookupPath)) {
            return true;
        }
        boolean bl = hasSuffix = pattern.indexOf(46) != -1;
        return !hasSuffix && this.pathMatcher.match(pattern + ".*", lookupPath);
    }

    public static boolean isValidUrl(String urlString) {
        try {
            new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }
}

