/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher.v2;

import com.digiwin.loadbalance.matcher.v2.DWAbstractMatcherV2;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UriComponentsBuilder;

@Order(value=0x7FFFFFFF)
public class UrlPathMatcherV2
extends DWAbstractMatcherV2 {
    AntPathMatcher antPathMatcher = new AntPathMatcher();

    public boolean canApply(HttpUriRequest request) {
        return true;
    }

    public String getCacheKey(HttpUriRequest request) {
        return request.getURI().getPath();
    }

    public boolean match(Map<String, String> instanceMetadata, HttpUriRequest request, boolean vesionAble) {
        String key;
        String contextPath = instanceMetadata.getOrDefault("server_context_path", "");
        String requestPath = "";
        try {
            requestPath = request.getURI().toURL().getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        int index = 0;
        while (instanceMetadata.containsKey(key = String.format("dwapi.%d", index))) {
            String api = instanceMetadata.get(key);
            String[] apiSplits = api.split("\\|");
            if (apiSplits.length != 2) {
                ++index;
                continue;
            }
            String apiId = apiSplits[0];
            int tag = Integer.parseInt(apiSplits[1]);
            if (this.isVersionAble(new int[]{tag}) ^ vesionAble) {
                ++index;
                continue;
            }
            if (2 == (tag & 2)) {
                restfulUriComponents = UriComponentsBuilder.newInstance().path("/").path(contextPath).path("/").path("/restful/standard/").path(apiSplits[0]).build();
                fullpath = restfulUriComponents.getPath();
                if (this.match(fullpath, requestPath)) {
                    return true;
                }
            } else if (16 == (tag & 0x10)) {
                restfulUriComponents = UriComponentsBuilder.newInstance().path("/").path(contextPath).path("/").path(apiSplits[0]).build();
                fullpath = restfulUriComponents.getPath();
                if (this.match(fullpath, requestPath)) {
                    return true;
                }
            } else if (1 == (tag & 1)) {
                String[] subParts = apiId.split("/");
                String[] requestSplits = requestPath.split("/");
                if (requestSplits.length < 5 || !requestSplits[3].equals(subParts[1]) || subParts.length < 4) {
                    ++index;
                    continue;
                }
                if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod()) && requestSplits.length >= 5) {
                    if ((subParts[2].equals(requestSplits[4]) || subParts[2].equals("I" + requestSplits[4].substring(0, 1).toUpperCase() + requestSplits[4].substring(1) + "Service")) && this.serviceMethodMatch(request.getMethod(), requestSplits, subParts[3])) {
                        return true;
                    }
                } else if (requestSplits.length >= 5) {
                    Object resource = requestSplits[4];
                    String serviceName = "I" + (String)(resource = ((String)resource).substring(0, 1).toUpperCase() + ((String)resource).substring(1)) + "Service";
                    if (subParts[2].equals(serviceName) && this.serviceMethodMatch(request.getMethod(), requestSplits, subParts[3])) {
                        return true;
                    }
                }
            }
            ++index;
        }
        return false;
    }

    private boolean serviceMethodMatch(String requestMethodName, String[] uriParts, String pattern) {
        Object methodName = requestMethodName.toLowerCase();
        if (uriParts.length > 5) {
            String[] subResourceArray;
            for (String subResource : subResourceArray = Arrays.copyOfRange(uriParts, 5, uriParts.length)) {
                methodName = (String)methodName + subResource.substring(0, 1).toUpperCase() + subResource.substring(1);
            }
        }
        if (((String)methodName).equals(pattern)) {
            return true;
        }
        return uriParts.length == 6 && "post".equalsIgnoreCase(requestMethodName) && uriParts[5].equals(pattern);
    }

    private boolean match(String pattern, String lookupPath) {
        boolean hasSuffix;
        if (pattern.equals(lookupPath)) {
            return true;
        }
        if (this.antPathMatcher.match(pattern, lookupPath)) {
            return true;
        }
        if (!pattern.endsWith("/") && this.antPathMatcher.match(pattern + "/", lookupPath)) {
            return true;
        }
        boolean bl = hasSuffix = pattern.indexOf(46) != -1;
        return !hasSuffix && this.antPathMatcher.match(pattern + ".*", lookupPath);
    }
}

