/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.service;

import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.UserTokenService;
import com.digiwin.loadbalance.service.TenantIdService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

public class DefaultTenantIdService
implements TenantIdService {
    private static Log log = LogFactory.getLog(DefaultTenantIdService.class);
    @Autowired
    @Qualifier(value="dwUserTokenService")
    UserTokenService userTokenService;
    Cache<String, String> tokenCach = CacheBuilder.newBuilder().initialCapacity(3000).maximumSize(15000L).expireAfterAccess(15L, TimeUnit.MINUTES).build();

    public String getTenantId(String token) throws Exception {
        log.info((Object)("DefaultTenantIdService verifyToken token :" + token));
        if (!StringUtils.hasText((String)token)) {
            return null;
        }
        return (String)this.tokenCach.get((Object)token, () -> {
            String responseBody;
            JSONObject responseJson;
            HttpResponseModel iamResult = this.userTokenService.verifyToken(token);
            if (iamResult != null && iamResult.getHttpStatusCode() == 200 && (responseJson = new JSONObject(responseBody = iamResult.getResponseBody())).has("tenantId")) {
                return responseJson.getString("tenantId");
            }
            throw new Exception("iam verifyToken fail iamResult:" + String.valueOf(iamResult));
        });
    }
}

