/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.client.httpclient;

import com.digiwin.loadbalance.config.request.IRequestTimeOutConfigProvider;
import com.digiwin.loadbalance.config.request.LoadbalanceRequestConfig;
import com.digiwin.loadbalance.extend.spi.DWRouteProcess;
import com.digiwin.loadbalance.extend.spi.DWRouteProcessServiceLocated;
import com.digiwin.loadbalance.multiple.util.MutipleAppUtil;
import com.digiwin.loadbalance.namespace.DWLoadBalancerClientFactory;
import com.digiwin.loadbalance.properties.auth.AuthenProperties;
import com.digiwin.loadbalance.properties.multiple.MultipleAPPProperties;
import com.digiwin.loadbalance.service.TenantIdService;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public abstract class BaseHttpRoutePlanner
implements HttpRoutePlanner {
    private static Log log = LogFactory.getLog(BaseHttpRoutePlanner.class);
    public static final AtomicBoolean inited = new AtomicBoolean(false);
    private final LoadbalanceRequestConfig loadbalanceRequestConfig;
    final AuthenProperties authenProperties;
    private final DWLoadBalancerClientFactory loadBalancerClientFactory;
    final TenantIdService tenantIdService;
    DiscoveryClient discoveryClient;
    MultipleAPPProperties multipleAPPProperties;
    @Autowired
    IRequestTimeOutConfigProvider<RequestConfig> requestTimeOutConfigProvider;

    public BaseHttpRoutePlanner(AuthenProperties authenProperties, DWLoadBalancerClientFactory loadBalancerClientFactory, TenantIdService tenantIdService, DiscoveryClient discoveryClient, MultipleAPPProperties multipleAPPProperties, LoadbalanceRequestConfig loadbalanceRequestConfig) {
        this.authenProperties = authenProperties;
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        this.tenantIdService = tenantIdService;
        this.discoveryClient = discoveryClient;
        this.multipleAPPProperties = multipleAPPProperties;
        this.loadbalanceRequestConfig = loadbalanceRequestConfig;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (inited.get()) return;
        Class<BaseHttpRoutePlanner> clazz = BaseHttpRoutePlanner.class;
        synchronized (BaseHttpRoutePlanner.class) {
            inited.compareAndSet(false, true);
            this.loadExtendProcess();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void loadExtendProcess() {
        DWRouteProcessServiceLocated.load();
    }

    public HttpHost beforeRoute(HttpHost httpHost, HttpRequest request, HttpContext context) {
        if (null == httpHost || null == request) {
            throw new IllegalArgumentException("httphost and request must not be null");
        }
        DWRouteProcess extendProcesse = DWRouteProcessServiceLocated.getPriorityProcess();
        if (null == extendProcesse) {
            return httpHost;
        }
        HttpHost processedHost = extendProcesse.beforeRoute(httpHost, request);
        if (null == processedHost) {
            return httpHost;
        }
        return processedHost;
    }

    public AuthenProperties getAuthenProperties() {
        return this.authenProperties;
    }

    public DWLoadBalancerClientFactory getLoadBalancerClientFactory() {
        return this.loadBalancerClientFactory;
    }

    public String getTenantId(HttpRequestWrapper wrapRequest) throws Exception {
        String tenantId = null;
        tenantId = this.getRouteKey(wrapRequest);
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            log.info((Object)("loadbalanceRoute routeKey:" + tenantId + ",url:" + wrapRequest.getURI()));
            return tenantId;
        }
        String token = this.getToken(wrapRequest);
        log.info((Object)("loadbalanceRoute token:" + token + ",url:" + wrapRequest.getURI()));
        tenantId = this.tenantIdService.getTenantId(token);
        return tenantId;
    }

    private String getRouteKey(HttpRequestWrapper wrapRequest) {
        return this.getPriorityRequestHeader(wrapRequest, this.getAuthenProperties().getRouteKeyNamesList());
    }

    private String getToken(HttpRequestWrapper wrapRequest) {
        return this.getPriorityRequestHeader(wrapRequest, this.getAuthenProperties().getTokenNamesList());
    }

    private String getPriorityRequestHeader(HttpRequestWrapper wrapRequest, List<String> names) {
        for (String name : names) {
            Header header = wrapRequest.getFirstHeader(name);
            if (null == header) continue;
            return header.getValue();
        }
        return null;
    }

    public DiscoveryClient getDiscoveryClient() {
        return this.multipleAPPProperties.isMultipleApp() ? (DiscoveryClient)this.loadBalancerClientFactory.getInstance(MutipleAppUtil.getCurrentNameSpaceApp(), DiscoveryClient.class) : this.discoveryClient;
    }

    public LoadbalanceRequestConfig getLoadbalanceRequestConfig() {
        return this.loadbalanceRequestConfig;
    }

    protected RequestConfig getClientRequestConfig(LoadbalanceRequestConfig loadbalanceRequestConfig) {
        return RequestConfig.custom().setConnectTimeout(loadbalanceRequestConfig.getConnectTimeout()).setConnectionRequestTimeout(loadbalanceRequestConfig.getConnectionRequestTimeout()).setSocketTimeout(loadbalanceRequestConfig.getSocketTimeout()).build();
    }

    public void beforeLoadbalance(HttpHost httpHost, HttpRequest request, HttpContext context) {
        if (this.loadbalanceRequestConfig.isEnableRequestSizeLimit() && request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity().getContentLength() > this.loadbalanceRequestConfig.getMaxRequestSize() && this.loadbalanceRequestConfig.getMaxRequestSize() > 0L) {
            throw new RuntimeException("request body too large");
        }
        if (null == context.getAttribute(HttpRouteUtils.ORIGINAL_REQUEST_CONFIG) && null != context.getAttribute("http.request-config")) {
            context.setAttribute(HttpRouteUtils.ORIGINAL_REQUEST_CONFIG, context.getAttribute("http.request-config"));
        }
        context.setAttribute("http.request-config", this.requestTimeOutConfigProvider.getRequestConfig((Object)((RequestConfig)context.getAttribute("http.request-config"))));
    }
}

