/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.loadbalancer;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.digiwin.loadbalance.client.config.TenantServiceConfig;
import com.digiwin.loadbalance.exception.DWAPIServiceNotFoundException;
import com.digiwin.loadbalance.exception.DWStateModeServiceNotFoundException;
import com.digiwin.loadbalance.matcher.DWMatcher;
import com.digiwin.loadbalance.matcher.delegate.DWMatcherDelegate;
import com.digiwin.loadbalance.region.RegionSwitch;
import com.digiwin.loadbalance.region.RegionSwitchEvent;
import com.digiwin.loadbalance.util.DWLoadBalanceRequestUtils;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import com.digiwin.loadbalance.watch.NacosServerListWatcher;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWClientTenantRoundLoadBalancer
implements ServiceInstanceChooser,
ApplicationListener<RegionSwitchEvent> {
    private static Log log = LogFactory.getLog(DWClientTenantRoundLoadBalancer.class);
    private final AtomicInteger position;
    private DiscoveryClient discoveryClient;
    private Map<String, Cache<String, List<ServiceInstance>>> servicePathCacheMap;
    private TenantServiceConfig tenantServiceConfig;
    private String serviceId;
    private List<DWMatcherDelegate> matcherDelegates;
    private RegionSwitch regionSwitch;
    @Autowired
    List<DWMatcher> matchers;
    @Value(value="${dw.api.cache.inital:300}")
    private int api_cache_initial;
    @Value(value="${dw.api.cache.max:600}")
    private long api_cache_max;

    public DWClientTenantRoundLoadBalancer(DiscoveryClient discoveryClient, TenantServiceConfig tenantServiceConfig, String serviceId, NacosServerListWatcher nacosServerListWatcher, RegionSwitch regionSwitch, List<DWMatcherDelegate> matcherDelegates) throws NacosException {
        this.discoveryClient = discoveryClient;
        this.tenantServiceConfig = tenantServiceConfig;
        this.servicePathCacheMap = new ConcurrentHashMap<String, Cache<String, List<ServiceInstance>>>();
        this.serviceId = serviceId;
        this.position = new AtomicInteger(new Random().nextInt(1000));
        this.regionSwitch = regionSwitch;
        this.matcherDelegates = matcherDelegates;
        nacosServerListWatcher.watch(serviceId, event -> {
            if (event instanceof NamingEvent) {
                log.info((Object)("nacos NamingEvent in DWClientTenantRoundLoadBalancer  ServiceName:" + ((NamingEvent)event).getServiceName() + ",clusters:" + ((NamingEvent)event).getClusters()));
                this.servicePathCacheMap.clear();
            }
        });
    }

    public ServiceInstance choose(String serviceId) {
        ServiceInstance serviceInstance;
        HttpUriRequest request = DWLoadBalanceRequestUtils.getRequest();
        log.info((Object)("DWTenantRoundLoadBalancer choose start path:" + request.getURI().getPath()));
        String tenantId = this.getTentid();
        DWMatcherDelegate matcherDelegate = this.getMatcherDelegate(DWLoadBalanceRequestUtils.getRequest());
        String cacheKey = matcherDelegate.getCacheKey(DWLoadBalanceRequestUtils.getRequest());
        String tenantServiceVersion = this.tenantServiceConfig.getServiceVersion(tenantId);
        List targetInstances = null;
        Cache pathListCache = this.servicePathCacheMap.get(tenantServiceVersion);
        if (Objects.isNull(pathListCache)) {
            pathListCache = CacheBuilder.newBuilder().initialCapacity(this.api_cache_initial).maximumSize(this.api_cache_max).build();
            this.servicePathCacheMap.put(tenantServiceVersion, (Cache<String, List<ServiceInstance>>)pathListCache);
        }
        try {
            targetInstances = StringUtils.hasText((String)cacheKey) ? (List)pathListCache.get((Object)cacheKey, () -> this.getInstances(tenantServiceVersion, request, matcherDelegate)) : this.getInstances(tenantServiceVersion, request, matcherDelegate);
        }
        catch (ExecutionException e) {
            log.error((Object)("fail to find serviceInstances tenantId:" + tenantId + " cacheKey:" + cacheKey + " serviceId:" + serviceId + " version:" + tenantServiceVersion), (Throwable)e);
        }
        if (CollectionUtils.isEmpty(targetInstances)) {
            log.error((Object)("no service instance was found  after api filter tenantId:" + tenantId + " , serviceId:" + serviceId));
            throw new DWAPIServiceNotFoundException(HttpRouteUtils.API_INSTANCE_NOT_FOUND_ERROR_MESSAGE + serviceId);
        }
        Optional regionPredicateOptional = this.regionSwitch.getRegionPredicate(this.getTentid());
        if (regionPredicateOptional.isPresent() && !CollectionUtils.isEmpty((Collection)targetInstances)) {
            targetInstances = targetInstances.stream().filter((Predicate)regionPredicateOptional.get()).collect(Collectors.toList());
        }
        if (null == (serviceInstance = this.selectInstance(targetInstances))) {
            log.error((Object)("no service instance was found  after region filter tenantId:" + tenantId + " , serviceId:" + serviceId));
            throw new DWStateModeServiceNotFoundException(HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_MESSAGE + serviceId);
        }
        return serviceInstance;
    }

    List<ServiceInstance> getInstances(String tenantServiceVersion, HttpUriRequest request, DWMatcherDelegate matcher) {
        List discoverInstances = null;
        if (!"default".equals(tenantServiceVersion)) {
            discoverInstances = this.discoveryClient.getInstances(this.serviceId).stream().filter(instance -> tenantServiceVersion.equals(instance.getMetadata().get("version"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(discoverInstances)) {
                return new ArrayList<ServiceInstance>();
            }
            discoverInstances = discoverInstances.stream().filter(instance -> this.instanceMatch((ServiceInstance)instance, request, matcher, true)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(discoverInstances)) {
            discoverInstances = this.discoveryClient.getInstances(this.serviceId).stream().filter(instance -> this.instanceMatch((ServiceInstance)instance, request, matcher, false)).collect(Collectors.toList());
        }
        return discoverInstances;
    }

    public boolean instanceMatch(ServiceInstance serviceInstance, HttpUriRequest request, DWMatcherDelegate matcherDelegate, boolean vesionAble) {
        return matcherDelegate.match(serviceInstance, request, vesionAble);
    }

    public boolean instancePathMatch(ServiceInstance serviceInstance, HttpUriRequest request, DWMatcher matcher, String prefix, String suffix) {
        String key;
        String loadblance_version = null;
        Map metadata = serviceInstance.getMetadata();
        if (!CollectionUtils.isEmpty((Map)metadata)) {
            loadblance_version = (String)metadata.get("loadbalance_version");
        }
        int index = 0;
        while (metadata.containsKey(key = String.format(prefix + ".%d." + suffix, index))) {
            String pathRegex = (String)metadata.get(key);
            if (matcher.match(pathRegex, request)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private ServiceInstance selectInstance(List<ServiceInstance> serviceInstanceList) {
        if (CollectionUtils.isEmpty(serviceInstanceList)) {
            return null;
        }
        int pos = this.position.incrementAndGet() & Integer.MAX_VALUE;
        return serviceInstanceList.get(pos % serviceInstanceList.size());
    }

    private String getTentid() {
        return DWLoadBalanceRequestUtils.getTenantId();
    }

    private DWMatcherDelegate getMatcherDelegate(HttpUriRequest request) {
        return this.matcherDelegates.stream().filter(dwMatcherDelegate -> dwMatcherDelegate.canApply(request)).findFirst().get();
    }

    public void onApplicationEvent(RegionSwitchEvent event) {
        if (event.getServiceName().equals(this.serviceId)) {
            this.servicePathCacheMap.clear();
        }
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        return null;
    }
}

