/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.extend.spi;

import com.dap.component.loadbalance.api.LoadbalanceClassLoaderProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.loadbalance.extend.spi.DWRouteProcess;
import com.digiwin.loadbalance.extend.spi.DummyRouteProcess;
import com.digiwin.loadbalance.extend.spi.Ordered;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class DWRouteProcessServiceLocated {
    private static Log log = LogFactory.getLog(DWRouteProcessServiceLocated.class);
    public static Map<ClassLoader, DWRouteProcess> extendProcessMap = new ConcurrentHashMap<ClassLoader, DWRouteProcess>();
    public static DWRouteProcess plantformProcess = null;
    public static DWRouteProcess applicationProcess = null;
    private static DummyRouteProcess dummyRouteProcess = new DummyRouteProcess();

    public static void load() {
        try {
            DWRouteProcessServiceLocated.loadModuleProcess();
        }
        catch (Throwable e) {
            log.error((Object)"load module appid mapping service error,", e);
        }
        try {
            DWRouteProcessServiceLocated.loadApplicationProcess();
        }
        catch (Throwable e) {
            log.error((Object)"load application appid mapping service error,", e);
        }
        try {
            DWRouteProcessServiceLocated.loadPlantFormProcess();
        }
        catch (Throwable e) {
            log.error((Object)"load platform appid mapping service error,", e);
        }
    }

    public static DWRouteProcess getPriorityProcess() {
        ClassLoader classLoader = DWRouteProcessServiceLocated.deduceClassLoader();
        DWRouteProcess extendProcess = extendProcessMap.get(classLoader);
        if (extendProcess == null && classLoader != null) {
            List<DWRouteProcess> extendProcesses = DWRouteProcessServiceLocated.loadService(classLoader);
            if (CollectionUtils.isEmpty(extendProcesses)) {
                if (applicationProcess != null) {
                    extendProcessMap.put(classLoader, applicationProcess);
                    return applicationProcess;
                }
                if (plantformProcess != null) {
                    extendProcessMap.put(classLoader, plantformProcess);
                    return plantformProcess;
                }
                extendProcessMap.put(classLoader, dummyRouteProcess);
                return dummyRouteProcess;
            }
            extendProcessMap.put(classLoader, extendProcesses.get(0));
            return extendProcesses.get(0);
        }
        return extendProcess;
    }

    public static List<DWRouteProcess> loadPlantFormProcess() {
        List<DWRouteProcess> extendProcesses = DWRouteProcessServiceLocated.loadService(ClassLoader.getSystemClassLoader());
        if (!CollectionUtils.isEmpty(extendProcesses)) {
            plantformProcess = extendProcesses.get(0);
            extendProcessMap.put(ClassLoader.getSystemClassLoader(), plantformProcess);
        }
        return extendProcesses;
    }

    public static List<DWRouteProcess> loadApplicationProcess() {
        LoadbalanceClassLoaderProvider classLoaderProvider = (LoadbalanceClassLoaderProvider)SpringContextUtils.getBean((String)"loadbalanceClassLoaderProvider");
        ClassLoader classLoader = classLoaderProvider.getApplicationClassLoader();
        List<DWRouteProcess> extendProcesses = DWRouteProcessServiceLocated.loadService(classLoader);
        if (!CollectionUtils.isEmpty(extendProcesses)) {
            applicationProcess = extendProcesses.get(0);
            extendProcessMap.put(classLoader, applicationProcess);
        }
        return extendProcesses;
    }

    public static void loadModuleProcess() {
        Map moduleClassLoaderMap = null;
        LoadbalanceClassLoaderProvider classLoaderProvider = (LoadbalanceClassLoaderProvider)SpringContextUtils.getBean((String)"loadbalanceClassLoaderProvider");
        moduleClassLoaderMap = classLoaderProvider.getModuleClassLoaders();
        if (CollectionUtils.isEmpty((Map)moduleClassLoaderMap)) {
            return;
        }
        for (Map.Entry moduleClassLoaderEntry : moduleClassLoaderMap.entrySet()) {
            ClassLoader moduleClassLoader = (ClassLoader)moduleClassLoaderEntry.getValue();
            List<DWRouteProcess> extendProcesses = DWRouteProcessServiceLocated.loadService(moduleClassLoader);
            if (!CollectionUtils.isEmpty(extendProcesses)) {
                extendProcessMap.put(moduleClassLoader, extendProcesses.get(0));
                continue;
            }
            if (applicationProcess != null) {
                extendProcessMap.put(moduleClassLoader, applicationProcess);
                continue;
            }
            if (plantformProcess != null) {
                extendProcessMap.put(moduleClassLoader, plantformProcess);
                continue;
            }
            extendProcessMap.put(moduleClassLoader, dummyRouteProcess);
        }
    }

    public static List<DWRouteProcess> loadService(ClassLoader classLoader) {
        ServiceLoader<DWRouteProcess> load = ServiceLoader.load(DWRouteProcess.class, classLoader);
        Iterator<DWRouteProcess> iterator = load.iterator();
        ArrayList<DWRouteProcess> extendProcesses = new ArrayList<DWRouteProcess>();
        while (iterator.hasNext()) {
            extendProcesses.add(iterator.next());
        }
        extendProcesses.sort(Comparator.comparingInt(Ordered::getOrder));
        return extendProcesses;
    }

    private static DWRouteProcess deeuceExtendProcess() {
        return null;
    }

    private static ClassLoader deduceClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = DWRouteProcessServiceLocated.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

