/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import com.digiwin.app.log.operation.vo.IDWLogOperationVo;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public abstract class DWAbstractLogOperationWorker
implements Runnable {
    private final Log LOGGER_ = LogFactory.getLog(this.getClass());
    private boolean isDebug = this.LOGGER_.isDebugEnabled();
    protected boolean tenantEnable = BooleanUtils.toBoolean((String)System.getProperty("tenantEnabled", "true"));
    protected String tenantColumnName = System.getProperty("tenantColumnname", "tenantsid");
    protected DWLogOperationContext logOperationContext;
    private String traceId;
    private final DWLogOperationCollection logOperationVoCollection;

    public DWAbstractLogOperationWorker(DWLogOperationCollection logOperationVoCollection, DWLogOperationContext logOperationContext) {
        this.logOperationVoCollection = logOperationVoCollection;
        this.logOperationContext = logOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StopWatch stopWatch = StopWatch.createStarted();
        this.traceId = this.logOperationContext.getServiceInfoData().getTraceId();
        ThreadContext.put((String)"traceId", (String)this.traceId);
        String currentThreadName = Thread.currentThread().getName();
        if (this.isDebug) {
            this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, starting...(traceId:%s))", currentThreadName, this.traceId));
        }
        try {
            this.process(this.logOperationVoCollection);
        }
        catch (Exception e) {
            try {
                this.LOGGER_.info((Object)String.format("[DWLogOperationWorker] thread:%s, exception:%s (traceId:%s)", currentThreadName, e.getCause(), this.traceId));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                if (this.isDebug) {
                    this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d ms (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
                }
                throw throwable;
            }
            stopWatch.stop();
            if (this.isDebug) {
                this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d ms (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
            }
        }
        stopWatch.stop();
        if (this.isDebug) {
            this.LOGGER_.debug((Object)String.format("[DWLogOperationWorker] thread:%s, takes %d ms (traceId:%s))", currentThreadName, stopWatch.getTime(), this.traceId));
        }
    }

    protected void process(Object data) {
        try {
            if (data instanceof DWLogOperationCollection) {
                for (IDWLogOperationVo voRow : ((DWLogOperationCollection)data).getVoList()) {
                    this.writeData(voRow);
                }
            } else if (data instanceof IDWLogOperationVo) {
                this.writeData((IDWLogOperationVo)data);
            }
        }
        catch (Exception exp) {
            this.LOGGER_.info((Object)("[DWLogOperationWorker] writeData process:" + exp.fillInStackTrace()));
        }
    }

    protected abstract void writeData(IDWLogOperationVo var1) throws Exception;
}

