/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.concurrent;

import com.dap.component.log.operation.api.LogOperationWriter;
import com.digiwin.app.log.operation.concurrent.DWLogOperationThreadFactory;
import com.digiwin.app.log.operation.config.DWLogOperationThreadProperties;
import com.digiwin.app.log.operation.context.DWLogOperationContext;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class DWLogOperationAsyncWriter
implements LogOperationWriter,
InitializingBean,
DisposableBean {
    private final Log log = LogFactory.getLog(DWLogOperationAsyncWriter.class);
    boolean isDebug = this.log.isDebugEnabled();
    private static final int DESTROY_TIMEOUT = 3000;
    private ExecutorService executor;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private DWLogOperationThreadProperties threadProperties;

    public void afterPropertiesSet() {
        DWLogOperationThreadFactory threadFactory = new DWLogOperationThreadFactory("DWLogOperationWriter-", true);
        this.executor = new ThreadPoolExecutor(this.threadProperties.getCorePoolSize(), this.threadProperties.getMaximumPoolSize(), this.threadProperties.getKeepAliveTime(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.threadProperties.getWorkQueueSize()), threadFactory);
    }

    protected abstract Runnable createWritingLogJob(DWLogOperationCollection var1, DWLogOperationContext var2);

    @Override
    public void doWrite(Object logOperationVoCollection, DWLogOperationContext logOperationContext) {
        Objects.requireNonNull(logOperationVoCollection, "logOperationVoCollection is required");
        try {
            DWLogOperationContext workerLogOperationContext = logOperationContext.clone();
            Runnable job = this.createWritingLogJob((DWLogOperationCollection)logOperationVoCollection, logOperationContext);
            this.executor.execute(job);
            if (this.isDebug) {
                this.log.debug((Object)String.format("[%s] job submitted ", this.getClass().getSimpleName()));
            }
        }
        catch (Exception e) {
            this.log.info((Object)String.format("[%s] exception:", e.getCause()));
            e.printStackTrace();
        }
    }

    public void destroy() throws Exception {
        StopWatch stopWatch = StopWatch.createStarted();
        if (this.isClose.compareAndSet(false, true)) {
            this.log.info((Object)"DWLogOperationWriter.destroy()");
            ExecutorService executor = this.executor;
            if (executor != null) {
                executor.shutdown();
                try {
                    executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            stopWatch.stop();
            long l = Math.max(3000L - stopWatch.getTime(), 100L);
        }
    }

    public DWLogOperationThreadProperties getThreadProperties() {
        return this.threadProperties;
    }

    public void setThreadProperties(DWLogOperationThreadProperties threadProperties) {
        this.threadProperties = threadProperties;
    }
}

