/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.autoconfigure;

import com.dap.component.log.operation.api.LogOperationWriter;
import com.digiwin.app.log.operation.aop.DWLogOperationInterceptor;
import com.digiwin.app.log.operation.autoconfigure.condition.DWLogOperationCondition;
import com.digiwin.app.log.operation.autoconfigure.util.AESUtil;
import com.digiwin.app.log.operation.concurrent.DWLogOperationWriter;
import com.digiwin.app.log.operation.config.DWLogOperationPointcutProperties;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.config.DWLogOperationThreadProperties;
import com.digiwin.app.log.operation.dao.DWLogOperationDaoImp;
import com.digiwin.app.log.operation.dao.ILogOperationDao;
import java.util.HashMap;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@DependsOn(value={"dw-spring-context-utils", "dw-json-config"})
@Configuration
public class DWLogOperationAutoConfiguration {
    private static final Log LOGGER_ = LogFactory.getLog(DWLogOperationAutoConfiguration.class);

    @Bean(name={"dw-log-operation-configuration-properties"})
    @Conditional(value={DWLogOperationCondition.class})
    @ConditionalOnMissingBean
    public DWLogOperationProperties dwLogOperationConfigProperties(ApplicationContext context) {
        DWLogOperationProperties logOperationProperties = null;
        boolean operateLogEnabled = DWLogOperationCondition.isLogOperationEnabled(context.getEnvironment());
        if (operateLogEnabled) {
            Binder binder = Binder.get((Environment)context.getEnvironment());
            IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
            ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation");
            BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationProperties.class), (BindHandler)handler);
            logOperationProperties = (DWLogOperationProperties)bindResult.get();
        } else {
            logOperationProperties = new DWLogOperationProperties();
        }
        LOGGER_.info((Object)logOperationProperties.toString());
        return logOperationProperties;
    }

    @Bean(name={"dw-log-operation-db-dataSource"})
    @ConditionalOnBean(name={"dw-log-operation-configuration-properties"})
    @ConditionalOnExpression(value="!'${dap.dwlog.operation.datasource.url:}'.isEmpty()")
    public DataSource dwLogOperationDaoDataSource(ApplicationContext context, @Qualifier(value="dw-log-operation-configuration-properties") DWLogOperationProperties logOperationProperties) {
        String dbPasswordEncryptionKey = context.getEnvironment().getProperty("dap.dwlog.operation.datasource.password.encryption.key");
        if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
            String dbPassword = context.getEnvironment().getProperty("dap.dwlog.operation.datasource.password");
            dbPassword = AESUtil.decode(dbPassword, dbPasswordEncryptionKey);
            HashMap<String, String> dbPasswordDecodeMap = new HashMap<String, String>();
            dbPasswordDecodeMap.put("dap.dwlog.operation.datasource.password", dbPassword);
            MapPropertySource dapApplicationPropertysourceDecode = new MapPropertySource("dap-application-propertysource-dwlog-encode", dbPasswordDecodeMap);
            ((ConfigurableEnvironment)context.getEnvironment()).getPropertySources().addFirst((PropertySource)dapApplicationPropertysourceDecode);
        }
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.datasource");
        BindResult result = binder.bind(cfgPropertyName, Bindable.of(DataSourceProperties.class), (BindHandler)handler);
        DataSource defaultDataSource = ((DataSourceProperties)result.get()).initializeDataSourceBuilder().build();
        LOGGER_.info((Object)("dw-log-operation-db-dataSource: using " + defaultDataSource.getClass().toString()));
        return ((DataSourceProperties)result.get()).initializeDataSourceBuilder().build();
    }

    @Bean(name={"dw-log-operation-thread-configuration"})
    @ConditionalOnBean(name={"dw-log-operation-configuration-properties"})
    public DWLogOperationThreadProperties dwLogOperationThreadProperties(ApplicationContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.writer.thread");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationThreadProperties.class), (BindHandler)handler);
        DWLogOperationThreadProperties threadProperties = null;
        threadProperties = bindResult.isBound() ? (DWLogOperationThreadProperties)bindResult.get() : new DWLogOperationThreadProperties();
        LOGGER_.info((Object)threadProperties.toString());
        return threadProperties;
    }

    @Bean(name={"dw-log-operation-writer"})
    @ConditionalOnBean(name={"dw-log-operation-db-dataSource", "dw-log-operation-thread-configuration"})
    @ConditionalOnMissingBean(name={"dw-log-operation-writer"})
    public LogOperationWriter dwLogOperationWriter(@Qualifier(value="dw-log-operation-db-dataSource") DataSource dataSource, @Qualifier(value="dw-log-operation-thread-configuration") DWLogOperationThreadProperties threadProperties) {
        DWLogOperationWriter dwLogOperationWriter = new DWLogOperationWriter();
        dwLogOperationWriter.setThreadProperties(threadProperties);
        dwLogOperationWriter.setDataSource(dataSource);
        return dwLogOperationWriter;
    }

    @Bean(name={"dw-log-operation-dao"})
    @ConditionalOnBean(name={"dw-log-operation-writer"})
    @ConditionalOnMissingBean
    public ILogOperationDao dwLogOperationDao(@Qualifier(value="dw-log-operation-writer") LogOperationWriter dwLogOperationWriter) {
        DWLogOperationDaoImp dwLogOperationDao = new DWLogOperationDaoImp(dwLogOperationWriter);
        return dwLogOperationDao;
    }

    @Bean(name={"dw-log-operation-interceptor"})
    @ConditionalOnBean(name={"dw-log-operation-dao"})
    @ConditionalOnMissingBean
    public DWLogOperationInterceptor dwLogOperationInterceptor(@Qualifier(value="dw-log-operation-configuration-properties") DWLogOperationProperties logOperateProperties, @Qualifier(value="dw-log-operation-dao") ILogOperationDao dwLogOperationDao) {
        DWLogOperationInterceptor dwLogOperationInterceptor = new DWLogOperationInterceptor();
        return dwLogOperationInterceptor;
    }

    @Bean(name={"dw-log-operation-aop-pointcut-configuration"})
    @ConditionalOnBean(name={"dw-log-operation-configuration-properties"})
    public DWLogOperationPointcutProperties dwLogOperationPointcutProperties(ApplicationContext context) {
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwlog.operation.aop.pointcut");
        BindResult bindResult = binder.bind(cfgPropertyName, Bindable.of(DWLogOperationPointcutProperties.class), (BindHandler)handler);
        DWLogOperationPointcutProperties pointcutProperties = null;
        pointcutProperties = bindResult.isBound() ? (DWLogOperationPointcutProperties)bindResult.get() : new DWLogOperationPointcutProperties();
        LOGGER_.info((Object)("[DWLogOperationAutoConfiguration] pointcut properties:" + pointcutProperties.toString()));
        return pointcutProperties;
    }

    @Bean(name={"dw-log-operation-pointcut-advisor"})
    @ConditionalOnBean(name={"dw-log-operation-aop-pointcut-configuration"})
    public DefaultPointcutAdvisor dwLogOperationPointcutAdvisor(@Qualifier(value="dw-log-operation-interceptor") DWLogOperationInterceptor dwLogOperationInterceptor, @Qualifier(value="dw-log-operation-aop-pointcut-configuration") DWLogOperationPointcutProperties pointcutProperties) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(pointcutProperties.getExpression());
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dwLogOperationInterceptor);
        advisor.setOrder(pointcutProperties.getOrder());
        LOGGER_.info((Object)advisor.toString());
        return advisor;
    }
}

