/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.operation.dao;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLogOperationSqlCollector {
    private static Log _log = LogFactory.getLog(DWLogOperationSqlCollector.class);

    public static void writeSqlInfoToServiceContext(String sql, Map<String, Object> sqlLogOptions, Map<String, Object> operateLogData, Object ... params) {
        boolean configOfServiceLogForOperate = false;
        if (MapUtils.isNotEmpty(operateLogData) && operateLogData.containsKey("isLogRecord") && ((Boolean)operateLogData.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty(operateLogData) && operateLogData.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogData.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                collectSqlLogForOperate = sqlLogOptions != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)sqlLogOptions.get("logOperationEnabled")), (boolean)true)) : true;
            }
            if (collectSqlLogForOperate) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", Arrays.asList(params));
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogData.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogData.put("sqlMap", logRecordSqlMap);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b, combinedConfigValueOfSqlLogForOperate=%b, daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
            }
        }
    }
}

