/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.utils;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class DWMailUtils {
    private static final String MAIL_MIME_CHARSET = "utf8";
    private static final String CONTENT_CHARSET = "text/html; charset=utf8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doSendMail(String sender, String receiver, String ccList, String bccList, String smtpHost, int port, String username, String passwd, String subject, String content, Integer typeOfConnection) throws Exception {
        Transport transport = null;
        sender = username;
        try {
            System.setProperty("mail.mime.charset", MAIL_MIME_CHARSET);
            Properties props = DWMailUtils.setProperties(typeOfConnection, smtpHost, port);
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            mailSession.setDebug(false);
            Message msg = DWMailUtils.setMsgInfo(mailSession, sender, receiver, ccList, bccList, subject, content);
            transport = typeOfConnection == 0 ? mailSession.getTransport("smtp") : mailSession.getTransport("smtps");
            transport.connect(smtpHost, username, passwd);
            transport.sendMessage(msg, msg.getAllRecipients());
            boolean bl = true;
            DWMailUtils.closeTransport(transport);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DWMailUtils.closeTransport(transport);
        }
    }

    private static void closeTransport(Transport transport) throws MessagingException {
        if (transport != null) {
            transport.close();
        }
    }

    private static Message setMsgInfo(Session mailSession, String sender, String receiver, String ccList, String bccList, String subject, String content) throws AddressException, MessagingException {
        MimeMessage msg = new MimeMessage(mailSession);
        msg.setFrom((Address)new InternetAddress(sender));
        InternetAddress[] address = InternetAddress.parse((String)receiver, (boolean)false);
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        if (ccList != null && !ccList.equals("")) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccList));
        }
        if (bccList != null && !bccList.equals("")) {
            msg.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bccList));
        }
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setContent((Object)content, CONTENT_CHARSET);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp);
        msg.setContent((Multipart)mp);
        return msg;
    }

    private static Properties setProperties(int typeOfConnection, String smtpHost, int port) {
        Properties props = null;
        switch (typeOfConnection) {
            case 1: {
                props = DWMailUtils.getPropertyInTls(smtpHost, port);
                break;
            }
            case 2: {
                props = DWMailUtils.getPropertyInSsl(smtpHost, port);
                break;
            }
            default: {
                props = DWMailUtils.getPropertyInNormalConnection(smtpHost, port);
            }
        }
        return props;
    }

    private static Properties getPropertyInNormalConnection(String smtpHost, int port) {
        Properties props = new Properties();
        props.put("mail.host", smtpHost);
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.port", (Object)port);
        props.put("mail.smtp.auth", "true");
        return props;
    }

    private static Properties getPropertyInTls(String smtpHost, int port) {
        Properties props = new Properties();
        props.put("mail.host", smtpHost);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.port", (Object)port);
        return props;
    }

    private static Properties getPropertyInSsl(String smtpHost, int port) {
        Properties props = new Properties();
        props.put("mail.host", smtpHost);
        props.put("mail.smtps.auth", "true");
        props.put("mail.smtps.port", (Object)port);
        props.put("mail.smtps.socketFactory.port", (Object)port);
        props.put("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtps.socketFactory.fallback", "true");
        props.put("mail.smtps.ssl.enable", "true");
        return props;
    }
}

