/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DWMybatisSqlManagementField
implements IDWSQLFilter {
    private static String DWMybatisMgmtAffix = "%%";
    private static boolean mgmtFieldEnabled = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().isMgmtFieldEnabled();
    public static String OPTION_MANAGEMENT_FIELD_ENABLED = "mgmtFieldEnabled";
    public static String OPTION_MANAGEMENT_FIELD_IGNORE_CUSTOM_VALUE = "mgmtFieldIgnoreCustomValue";
    public static String OPTION_MANAGEMENT_FIELD_ALIAS_NAME = "mgmtFieldAliasName";
    public static String PROPERTY_KEY_MGMT_FIELD_RESOLVER = "mgmtFieldResolver";
    public static String TAG_MGMT_FIELD_INSERT_COLUMNS = DWMybatisMgmtAffix + "{mgmtFieldInsertColumns}" + DWMybatisMgmtAffix;
    public static String TAG_MGMT_FIELD_INSERT_PARAMS = DWMybatisMgmtAffix + "{mgmtFieldInsertParams}" + DWMybatisMgmtAffix;
    public static String TAG_MGMT_FIELD_UPDATE_COLUMNS = DWMybatisMgmtAffix + "{mgmtFieldUpdateColumns}" + DWMybatisMgmtAffix;
    public static String TAG_DISABLE_MGMT_FIELDS = DWMybatisMgmtAffix + "-${mgmtField}" + DWMybatisMgmtAffix;
    private IDWManagementFieldResolver mgmtFieldResolver;
    private static boolean ignoreCustomValue = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().isMgmtFieldIgnoreCustomValue();

    public DWMybatisSqlManagementField(IDWManagementFieldResolver mgmtFieldResolver) {
        if (mgmtFieldResolver == null) {
            throw new IllegalArgumentException("mgmtFieldResolver is null!");
        }
        this.mgmtFieldResolver = mgmtFieldResolver;
    }

    public static boolean isEnabled() {
        return mgmtFieldEnabled;
    }

    public static boolean isIgnoreCustomValue() {
        return ignoreCustomValue;
    }

    public static void disableInOptions(IDWSQLOptions options) {
        DWMybatisSqlManagementField.setEnabledInOptions(options, false);
    }

    public static void setEnabledInOptions(IDWSQLOptions options, boolean enabled) {
        options.set(OPTION_MANAGEMENT_FIELD_ENABLED, (Object)enabled);
    }

    public static void setIgnoreCustomValueInOptions(IDWSQLOptions options, boolean ignored) {
        options.set(OPTION_MANAGEMENT_FIELD_IGNORE_CUSTOM_VALUE, (Object)ignored);
    }

    public static boolean isEnabled(IDWSQLOptions options) {
        if (options == null) {
            return mgmtFieldEnabled;
        }
        boolean enabled = (Boolean)options.get(OPTION_MANAGEMENT_FIELD_ENABLED, (Object)DWMybatisSqlManagementField.isEnabled());
        return enabled;
    }

    public static void setManagementFieldAliasName(IDWSQLOptions options, String aliasName) {
        options.set(OPTION_MANAGEMENT_FIELD_ALIAS_NAME, (Object)aliasName);
    }

    public static boolean isIgnoreCustomValue(IDWSQLOptions options) {
        if (options == null) {
            return ignoreCustomValue;
        }
        boolean ignored = (Boolean)options.get(OPTION_MANAGEMENT_FIELD_IGNORE_CUSTOM_VALUE, (Object)DWMybatisSqlManagementField.isIgnoreCustomValue());
        return ignored;
    }

    public static String getManagementFieldAliasName(IDWSQLOptions options) {
        if (options == null) {
            return "";
        }
        String managementFieldAliasName = (String)options.get(OPTION_MANAGEMENT_FIELD_ALIAS_NAME, (Object)"");
        return managementFieldAliasName;
    }

    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        String sql = sqlInfo.getSql();
        List parameters = sqlInfo.getParametersAsList();
        if (DWMybatisSqlManagementField.isEnabled(options)) {
            CharSequence[] insertFields = this.mgmtFieldResolver.getInsertFields();
            String[] updateFields = this.mgmtFieldResolver.getUpdateFields();
            boolean insertFieldCountZero = insertFields.length == 0;
            boolean hasTag = false;
            if (sql.contains(TAG_DISABLE_MGMT_FIELDS)) {
                hasTag = true;
                sql = sql.replaceAll(Pattern.quote(TAG_DISABLE_MGMT_FIELDS), "");
            }
            if (sql.contains(TAG_MGMT_FIELD_INSERT_COLUMNS)) {
                hasTag = true;
                String replacedColumnString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", insertFields);
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_INSERT_COLUMNS), replacedColumnString);
            }
            if (sql.contains(TAG_MGMT_FIELD_INSERT_PARAMS)) {
                hasTag = true;
                String replacedParameterString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", Collections.nCopies(insertFields.length, "?"));
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_INSERT_PARAMS), replacedParameterString);
                parameters.addAll(this.mgmtFieldResolver.getInsertFieldValues());
            }
            if (sql.contains(TAG_MGMT_FIELD_UPDATE_COLUMNS)) {
                hasTag = true;
                ArrayList<CallSite> columnValueSetList = new ArrayList<CallSite>();
                String updateFieldAliasName = DWMybatisSqlManagementField.getManagementFieldAliasName(options);
                for (String updateField : updateFields) {
                    Object value = this.mgmtFieldResolver.getFieldValue(updateField);
                    String columnValueSet = !"".equals(updateFieldAliasName) ? updateFieldAliasName + "." + updateField + "=" : updateField + "=";
                    columnValueSet = columnValueSet + (String)(value == null ? "null" : "'" + value.toString() + "'");
                    columnValueSetList.add((CallSite)((Object)columnValueSet));
                }
                String replacedParameterString = (columnValueSetList.size() == 0 ? "" : ", ") + String.join((CharSequence)", ", columnValueSetList);
                sql = sql.replaceAll(Pattern.quote(TAG_MGMT_FIELD_UPDATE_COLUMNS), replacedParameterString);
            }
            if (!hasTag) {
                throw new DWDataException("13014", String.format("[DWSQLManagementFieldFilter] related management field tag(%s/%s/%s) is missing in sql.", TAG_MGMT_FIELD_INSERT_COLUMNS, TAG_MGMT_FIELD_INSERT_PARAMS, TAG_MGMT_FIELD_UPDATE_COLUMNS));
            }
        }
        sql = sql.replaceAll(Pattern.quote(TAG_DISABLE_MGMT_FIELDS), "");
        sqlInfo.setSqlAndParameters(sql, parameters);
    }

    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
    }

    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
        if (!DWMybatisSqlManagementField.isEnabled(options)) {
            return;
        }
        String[] targetFields = null;
        String[] oppsiteFields = null;
        if (dataRow.isNew()) {
            targetFields = this.mgmtFieldResolver.getInsertFields();
            if (!DWMybatisSqlManagementField.isIgnoreCustomValue(options)) {
                oppsiteFields = this.mgmtFieldResolver.getUpdateFields();
            }
        } else if (dataRow.isUpdate()) {
            targetFields = this.mgmtFieldResolver.getUpdateFields();
            if (!DWMybatisSqlManagementField.isIgnoreCustomValue(options)) {
                oppsiteFields = this.mgmtFieldResolver.getInsertFields();
            }
        }
        if (oppsiteFields != null) {
            Map data = dataRow.getData();
            String[] stringArray = oppsiteFields;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String notAllowedFieldName = stringArray[i];
                data.remove(notAllowedFieldName);
            }
        }
        if (targetFields != null) {
            for (String fieldName : targetFields) {
                dataRow.set(fieldName, this.mgmtFieldResolver.getFieldValue(fieldName));
            }
        }
    }

    public IDWManagementFieldResolver getMgmtFieldResolver() {
        return this.mgmtFieldResolver;
    }
}

