/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.interceptor;

import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.mybatis.utils.DWManagementFieldUtil;
import com.digiwin.app.dao.mybatis.utils.DWMybatisSqlStatementHelper;
import com.digiwin.app.dao.properties.DWDaoProperties;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.springframework.beans.factory.InitializingBean;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DWManagementFieldInterceptor
implements Interceptor,
InitializingBean {
    private static Log log = LogFactory.getLog(DWManagementFieldInterceptor.class);
    IDWManagementFieldResolver resolver;

    public DWManagementFieldInterceptor(IDWManagementFieldResolver resolver) {
        this.resolver = resolver;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("DWManagementFieldInterceptor intercept method(name=%s)...", invocation.getMethod().getName()));
        }
        if (DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().isMgmtFieldEnabled()) {
            StatementHandler statementHandler = (StatementHandler)DWManagementFieldInterceptor.realTarget(invocation.getTarget());
            StatementHandler delegateStatementHandler = (StatementHandler)SystemMetaObject.forObject((Object)statementHandler).getValue("delegate");
            MappedStatement mappedStatement = (MappedStatement)SystemMetaObject.forObject((Object)delegateStatementHandler).getValue("mappedStatement");
            if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT || mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
                BoundSql boundSql = statementHandler.getBoundSql();
                MetaObject boundSqlMetaObject = SystemMetaObject.forObject((Object)boundSql);
                String sql = boundSql.getSql();
                if (DWMybatisSqlStatementHelper.checkTagExist(boundSql.getSql())) {
                    return invocation.proceed();
                }
                Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
                StringBuilder statementSqls = new StringBuilder();
                for (Statement statement : statements.getStatements()) {
                    if (statement instanceof Insert) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"process [insert] statement management field...");
                        }
                        this.processInsert((Insert)statement);
                    } else if (statement instanceof Update) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"process [update] statement management field......");
                        }
                        this.processUpdate((Update)statement);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("not support process statement[type = %s] management field!", mappedStatement.getSqlCommandType()));
                    }
                    statementSqls.append(statement.toString() + ";");
                }
                boundSqlMetaObject.setValue("sql", (Object)statementSqls.toString());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("not support process statement[type = %s] management field!", mappedStatement.getSqlCommandType()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"default dao properties management field is disabled!");
        }
        return invocation.proceed();
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return DWManagementFieldInterceptor.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }

    private void processInsert(Insert insert) {
        Table table = insert.getTable();
        if (DWManagementFieldUtil.isIgnore(table.getName()) || table.getAlias() != null && DWManagementFieldUtil.isIgnore(table.getAlias().getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("management field ignores table(name=%s, alias=%s)!", table.getName(), table.getAlias()));
            }
            return;
        }
        if (insert.isUseDuplicate()) {
            String[] updateFields;
            for (String fieldsName : updateFields = this.resolver.getUpdateFields()) {
                if (this.isIgnorField(table, fieldsName)) continue;
                insert.getDuplicateUpdateColumns().add(new Column(table, fieldsName));
                insert.getDuplicateUpdateExpressionList().add(this.getValueExpression(fieldsName));
            }
        }
        List columns = insert.getColumns();
        String[] insertFields = this.resolver.getInsertFields();
        ItemsList itemsList = insert.getItemsList();
        for (String fieldsName : insertFields) {
            if (insert.getItemsList() == null || this.isIgnorField(table, fieldsName)) continue;
            columns.add(new Column(fieldsName));
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExpressionLists().forEach(el -> el.getExpressions().add(this.getValueExpression(fieldsName)));
                continue;
            }
            ((ExpressionList)itemsList).getExpressions().add(this.getValueExpression(fieldsName));
        }
    }

    private void processUpdate(Update update) {
        String[] updateFields;
        Table table = update.getTable();
        if (DWManagementFieldUtil.isIgnore(table.getName()) && table.getAlias() != null && DWManagementFieldUtil.isIgnore(table.getAlias().getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("management field ignores table(name=%s, alias=%s)!", table.getName(), table.getAlias()));
            }
            return;
        }
        for (String fieldsName : updateFields = this.resolver.getUpdateFields()) {
            if (this.isIgnorField(table, fieldsName)) continue;
            update.getUpdateSets().add(new UpdateSet(new Column(fieldsName), this.getValueExpression(fieldsName)));
        }
    }

    private Expression getValueExpression(String filedName) {
        Object fieldValue = this.resolver.getFieldValue(filedName);
        if (fieldValue instanceof Time) {
            TimeValue timeValue = new TimeValue();
            return timeValue.withValue((Time)fieldValue);
        }
        if (fieldValue instanceof Timestamp) {
            TimestampValue timestampValue = new TimestampValue();
            timestampValue.setValue((Timestamp)fieldValue);
            return timestampValue;
        }
        if (fieldValue instanceof java.util.Date) {
            return new DateValue((Date)fieldValue);
        }
        return new StringValue(fieldValue.toString());
    }

    private boolean isIgnorField(Table table, String fieldsName) {
        return DWManagementFieldUtil.isIgnore(table.getName(), fieldsName) || table.getAlias() != null && DWManagementFieldUtil.isIgnore(table.getAlias().getName(), fieldsName);
    }

    public void afterPropertiesSet() throws Exception {
    }
}

