/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.interceptor;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.dap.component.mybatis.api.MybatisConfigProviderProvider;
import com.dap.component.mybatis.api.MybatisRequestContextProvider;
import com.digiwin.app.dao.mybatis.DWMybatisConstants;
import com.digiwin.app.dao.mybatis.utils.DWMybatisIgnoreTenantUtil;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;

public class DWMybatisTenantLineHandler
implements TenantLineHandler {
    private static String tenantColumnName = DWMybatisConstants.tenantColumnname;
    private static String IAM_TENANTSIDKEY = DWMybatisTenantLineHandler.getIAMTenantSidKey();

    private static String getIAMTenantSidKey() {
        MybatisConfigProviderProvider configProvider = (MybatisConfigProviderProvider)SpringContextUtils.getBean((String)"mybatisConfigProviderProvider");
        String IAM_TENANTSIDKEY = configProvider.getIAMTenantSidKey();
        return IAM_TENANTSIDKEY;
    }

    public Expression getTenantId() {
        Long tenantsid = null;
        MybatisRequestContextProvider requestContextProvider = (MybatisRequestContextProvider)SpringContextUtils.getBean((String)"mybatisRequestContextProvider");
        Map profile = requestContextProvider.getProfile();
        if (profile.containsKey(IAM_TENANTSIDKEY)) {
            tenantsid = (Long)profile.get(IAM_TENANTSIDKEY);
            return new LongValue(tenantsid.longValue());
        }
        return null;
    }

    public boolean ignoreTable(String tableName) {
        MybatisConfigProviderProvider configProvider = (MybatisConfigProviderProvider)SpringContextUtils.getBean((String)"mybatisConfigProviderProvider");
        if (!configProvider.isTenantenabled()) {
            return true;
        }
        return DWMybatisIgnoreTenantUtil.isIgnore(tableName);
    }

    public String getTenantIdColumn() {
        return tenantColumnName;
    }
}

