/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.interceptor;

import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.dao.filter.DWSQLTenantIsolationFilter;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import com.digiwin.app.dao.mybatis.DWMybatisConstants;
import com.digiwin.app.dao.mybatis.DWMybatisSqlManagementField;
import com.digiwin.app.dao.properties.DWDaoProperties;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Deprecated
public class DWMybatisSqlStatementInterceptor
implements Interceptor {
    private static Log _LOGGER = LogFactory.getLog(DWMybatisSqlStatementInterceptor.class);
    private static final String _CLASSTAG = "[" + DWMybatisSqlStatementInterceptor.class.getSimpleName() + "]";
    @Autowired
    ApplicationContext context;
    private int sqlLogMaxLength = 200;
    private static String tenantColumnName = DWMybatisConstants.tenantColumnname;
    private static String IAM_TENANTSIDKEY = DWTenantUtils.getIAMTenantSidKey();
    private static String tenantName = "tenantName";
    private static String tenantValue = "tenantValue";
    private static String dwMybatisSqlStatementAffix = "%%";
    private static String mybatisBaseTenantTag = "{" + tenantColumnName + "}";
    private static String mybatisBaseTenantNameTag = "{" + tenantName + "}";
    private static String mybatisBaseTenantValueTag = "{" + tenantValue + "}";
    private static String sqlTenantTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantTag + dwMybatisSqlStatementAffix;
    private static String sqlTenantNameTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantNameTag + dwMybatisSqlStatementAffix;
    private static String sqlTenantValueTagDD = dwMybatisSqlStatementAffix + mybatisBaseTenantValueTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantNameTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantNameTag + dwMybatisSqlStatementAffix;
    private static String sqlIgnoreTenantValueTagDD = dwMybatisSqlStatementAffix + "-" + mybatisBaseTenantValueTag + dwMybatisSqlStatementAffix;
    private static final String _matchQuoteEmpty = Matcher.quoteReplacement(" ");
    private static final HashSet<SqlCommandType> MgmtSqlCommandTypeSet = new HashSet<SqlCommandType>(Arrays.asList(SqlCommandType.INSERT, SqlCommandType.UPDATE));
    String regEx = "(?s).%%\\{.*?" + tenantColumnName + "\\}%%";
    String regExCheckTenantTag = "(?s).*?" + tenantColumnName + "\\}%%";
    String regExTagWithAlias = "(?s)%{2}\\{[/\\w-]+\\." + tenantColumnName + "\\}%{2}";
    String prefixRegex = "(?s)%{2}\\{";
    String postfixRegex = ".tenantsid\\}%{2}";
    private Pattern patternTagWithAlias = Pattern.compile(this.regExTagWithAlias);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        StopWatch stopWatch = new StopWatch();
        String sqlId = "";
        String originalSql = "";
        Map<Object, Object> mapperStatamentInfo = new HashMap();
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)target;
            BoundSql boundSql = statementHandler.getBoundSql();
            MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
            mapperStatamentInfo = this.getMappedStatementInfo(metaObject, boundSql);
            sqlId = mapperStatamentInfo.get("sqlId").toString();
            originalSql = boundSql.getSql();
            stopWatch.start();
            this.filterSqlStatement(statementHandler, mapperStatamentInfo);
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug((Object)String.format(_CLASSTAG + " %s filterSqlStatement() costs %d (ms)", mapperStatamentInfo.get("sqlId"), stopWatch.getTime()));
            }
            stopWatch.reset();
        }
        stopWatch.start();
        Object returnValue = null;
        try {
            returnValue = invocation.proceed();
        }
        catch (Throwable throwable) {
            stopWatch.stop();
            _LOGGER.debug((Object)String.format(_CLASSTAG + " %s invocation.proceed() costs %d ", sqlId, stopWatch.getTime()));
            throw throwable;
        }
        stopWatch.stop();
        _LOGGER.debug((Object)String.format(_CLASSTAG + " %s invocation.proceed() costs %d ", sqlId, stopWatch.getTime()));
        this.writeSqlInfoToServiceContext(originalSql, (List)mapperStatamentInfo.get("sqlParameters"), (IDWSQLOptions)mapperStatamentInfo.get("dw-mybatis-data-option"));
        return returnValue;
    }

    private void filterSqlStatement(StatementHandler statementHandler, Map<String, Object> mapperStatamentInfo) throws Exception {
        BoundSql boundSql = statementHandler.getBoundSql();
        SqlCommandType sqlCommandType = (SqlCommandType)mapperStatamentInfo.get("sqlCommandType");
        String sqlCommand = boundSql.getSql();
        if (_LOGGER.isDebugEnabled()) {
            _LOGGER.debug((Object)(_CLASSTAG + "[filterSqlStatement] TenantEnabled:" + DWTenantUtils.isTenantenabled() + ",before sql command:" + sqlCommand));
        }
        Object parameterObject = boundSql.getParameterObject();
        IDWSQLOptions dataOptions = null;
        if (parameterObject != null && parameterObject instanceof MapperMethod.ParamMap) {
            dataOptions = (IDWSQLOptions)((MapperMethod.ParamMap)parameterObject).getOrDefault((Object)"dw-mybatis-data-option", null);
        }
        sqlCommand = this.sqlCommandReplace(sqlCommandType, sqlCommand, dataOptions);
        Field field = boundSql.getClass().getDeclaredField("sql");
        field.setAccessible(true);
        field.set(boundSql, sqlCommand);
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private String sqlCommandReplace(SqlCommandType sqlCommandType, String sqlCommand, IDWSQLOptions dataOptions) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlIgnoreTenantTagDD), _matchQuoteEmpty);
        sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlIgnoreTenantNameTagDD), _matchQuoteEmpty);
        sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlIgnoreTenantValueTagDD), _matchQuoteEmpty);
        boolean tenantEnabled = DWSQLTenantIsolationFilter.isEnabled((IDWSQLOptions)dataOptions);
        String tenantLogPrefix = _CLASSTAG + "[sqlCommandReplace] tenantEnabled(" + tenantEnabled + ") ";
        if (tenantEnabled) {
            sqlCommand = this.covertTenantTag(sqlCommand);
        } else {
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantTagDD), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantNameTagDD), _matchQuoteEmpty);
            boolean isExistedTagWithAlias = this.patternTagWithAlias.matcher(sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantValueTagDD), _matchQuoteEmpty)).find();
            if (isExistedTagWithAlias) {
                sqlCommand = sqlCommand.replaceAll(this.prefixRegex, " ");
                sqlCommand = sqlCommand.replaceAll(this.postfixRegex, "");
            }
        }
        if (_LOGGER.isDebugEnabled()) {
            if (sqlCommand.matches(this.regExCheckTenantTag)) {
                _LOGGER.debug((Object)(tenantLogPrefix + " after clean tag, something wrong. Full sql:" + sqlCommand));
            } else {
                _LOGGER.debug((Object)(tenantLogPrefix + " after clean tag, " + StringUtils.abbreviate((String)sqlCommand, (int)0, (int)this.sqlLogMaxLength)));
            }
        }
        if (MgmtSqlCommandTypeSet.contains(sqlCommandType)) {
            String mgmtLogPrefix = _CLASSTAG + "[sqlCommandReplace] ";
            DWDaoProperties dwDaoProperties = DWDaoProperties.getDefaultProperties();
            if (dwDaoProperties != null && dwDaoProperties.getMgmtFieldProperties().isMgmtFieldEnabled()) {
                boolean mgmtEnabled = DWSQLManagementFieldFilter.isEnabled((IDWSQLOptions)dataOptions);
                mgmtLogPrefix = mgmtLogPrefix + "mgmtEnabled(" + mgmtEnabled + ") ";
                if (DWSQLManagementFieldFilter.isEnabled((IDWSQLOptions)dataOptions)) {
                    sqlCommand = this.covertMgmtTag(sqlCommand);
                }
            }
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_DISABLE_MGMT_FIELDS), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS), _matchQuoteEmpty);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS), _matchQuoteEmpty);
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug((Object)(tenantLogPrefix + " after clean tag, " + StringUtils.abbreviate((String)sqlCommand, (int)0, (int)this.sqlLogMaxLength)));
            }
        }
        return sqlCommand;
    }

    private String getInsertOrUpdateMgmtValueSql(List<Object> insertOrUpdateValues) {
        StringBuffer returnValue = new StringBuffer();
        for (Object rowValue : insertOrUpdateValues) {
            if (rowValue instanceof String) {
                returnValue.append(", '" + rowValue + "' ");
                continue;
            }
            if (rowValue instanceof Date) {
                returnValue.append(", '" + rowValue + "' ");
                continue;
            }
            returnValue.append(", " + rowValue + " ");
        }
        return returnValue.toString();
    }

    public void setProperties(Properties properties) {
        String sqlLogMaxLength = properties.getProperty("sqlLogMaxLength");
        if (NumberUtils.isDigits((String)sqlLogMaxLength)) {
            this.sqlLogMaxLength = NumberUtils.createInteger((String)sqlLogMaxLength);
        }
    }

    private String covertTenantTag(String sqlCommand) {
        Long tenantSid = null;
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile.containsKey(IAM_TENANTSIDKEY)) {
            tenantSid = (Long)profile.get(IAM_TENANTSIDKEY);
        }
        if (sqlCommand.contains(sqlTenantTagDD) || sqlCommand.contains(sqlTenantNameTagDD) || sqlCommand.contains(sqlTenantValueTagDD) || this.patternTagWithAlias.matcher(sqlCommand).find()) {
            if (tenantSid != null) {
                boolean isExistedTagWithAlias;
                if (sqlCommand.contains(sqlTenantTagDD)) {
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantTagDD), Matcher.quoteReplacement(" and " + tenantColumnName + "= " + tenantSid + " "));
                }
                if (sqlCommand.contains(sqlTenantNameTagDD)) {
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantNameTagDD), Matcher.quoteReplacement(", " + tenantColumnName));
                }
                if (sqlCommand.contains(sqlTenantValueTagDD)) {
                    sqlCommand = sqlCommand.replaceAll(Pattern.quote(sqlTenantValueTagDD), Matcher.quoteReplacement(", " + tenantSid + " "));
                }
                if (isExistedTagWithAlias = this.patternTagWithAlias.matcher(sqlCommand).find()) {
                    sqlCommand = sqlCommand.replaceAll(this.prefixRegex, " and ");
                    sqlCommand = sqlCommand.replaceAll(this.postfixRegex, "." + tenantColumnName + " = " + tenantSid);
                }
            } else {
                throw new DWDataException("13013", String.format("[DWSQLTenantIsolationFilter.doFilter] %s is missing in profile.", tenantColumnName));
            }
        }
        if (_LOGGER.isDebugEnabled()) {
            _LOGGER.debug((Object)(_CLASSTAG + "[covertTenantTag] result sqlCommand:" + sqlCommand));
        }
        return sqlCommand;
    }

    private String covertMgmtTag(String sqlCommand) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String mgmtFieldResolverClazz = DWDaoProperties.getDefaultProperties().getMgmtFieldProperties().getMgmtFieldResolver();
        Class<?> resolverClass = this.context.getClassLoader().loadClass(mgmtFieldResolverClazz);
        IDWManagementFieldResolver resolver = (IDWManagementFieldResolver)resolverClass.newInstance();
        DWSQLManagementFieldFilter filter = new DWSQLManagementFieldFilter(resolver);
        IDWManagementFieldResolver mgmtFieldResolver = filter.getMgmtFieldResolver();
        CharSequence[] insertFields = mgmtFieldResolver.getInsertFields();
        String[] updateFields = mgmtFieldResolver.getUpdateFields();
        boolean insertFieldCountZero = insertFields.length == 0;
        boolean hasTag = false;
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_DISABLE_MGMT_FIELDS)) {
            hasTag = true;
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_DISABLE_MGMT_FIELDS), "");
        }
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS)) {
            hasTag = true;
            String replacedColumnString = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", insertFields);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_COLUMNS), replacedColumnString);
        }
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS)) {
            hasTag = true;
            String paramValues = this.getInsertOrUpdateMgmtValueSql(mgmtFieldResolver.getInsertFieldValues());
            String replacedParameterString_dist = (insertFieldCountZero ? "" : ", ") + String.join((CharSequence)", ", Collections.nCopies(insertFields.length, "?"));
            String replacedParameterString = insertFieldCountZero ? "" : paramValues;
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_INSERT_PARAMS), replacedParameterString);
        }
        if (sqlCommand.contains(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS)) {
            hasTag = true;
            ArrayList<String> columnValueSetList = new ArrayList<String>();
            DWDataSetOperationOption options = new DWDataSetOperationOption();
            String updateFieldAliasName = DWMybatisSqlManagementField.getManagementFieldAliasName((IDWSQLOptions)options);
            for (String updateField : updateFields) {
                Object value = mgmtFieldResolver.getFieldValue(updateField);
                String columnValueSet = !"".equals(updateFieldAliasName) ? updateFieldAliasName + "." + updateField + "=" : updateField + "=";
                columnValueSet = columnValueSet + (value == null ? "null" : "'" + value.toString() + "'");
                columnValueSetList.add(columnValueSet);
            }
            String replacedParameterString = (columnValueSetList.size() == 0 ? "" : ", ") + String.join((CharSequence)", ", columnValueSetList);
            sqlCommand = sqlCommand.replaceAll(Pattern.quote(DWMybatisSqlManagementField.TAG_MGMT_FIELD_UPDATE_COLUMNS), replacedParameterString);
        }
        if (_LOGGER.isDebugEnabled()) {
            _LOGGER.debug((Object)(_CLASSTAG + String.format("[covertMgmtTag] hasTag(%b), result sqlCommand:%s", hasTag, StringUtils.abbreviate((String)sqlCommand, (int)0, (int)this.sqlLogMaxLength))));
        }
        return sqlCommand;
    }

    private Map<String, Object> getMappedStatementInfo(MetaObject metaStatementHandler, BoundSql boundSql) {
        HashMap<String, Object> statementInfo = new HashMap<String, Object>();
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        String sqlId = mappedStatement.getId();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject != null && parameterObject instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
            ArrayList<String> params = new ArrayList<String>();
            for (Map.Entry entry : paramMap.entrySet()) {
                params.add(entry.toString());
            }
            statementInfo.put("sqlParameters", params);
            IDWSQLOptions dataOptions = (IDWSQLOptions)((MapperMethod.ParamMap)parameterObject).getOrDefault((Object)"dw-mybatis-data-option", null);
            statementInfo.put("dataOptions", dataOptions);
        }
        statementInfo.put("sqlCommandType", sqlCommandType);
        statementInfo.put("sqlId", sqlId);
        return statementInfo;
    }

    private String formatSql(String sql, Object parameterObject, List<ParameterMapping> parameterMappingList) {
        if (sql == null || sql.length() == 0) {
            return "";
        }
        sql = this.beautifySql(sql);
        if (parameterObject == null || parameterMappingList == null || parameterMappingList.size() == 0) {
            return sql;
        }
        String sqlWithoutReplacePlaceholder = sql;
        try {
            if (parameterMappingList != null) {
                Class<?> parameterObjectClass = parameterObject.getClass();
                if (this.isStrictMap(parameterObjectClass)) {
                    DefaultSqlSession.StrictMap strictMap = (DefaultSqlSession.StrictMap)parameterObject;
                    if (this.isList(((Collection)strictMap.get((Object)"list")).getClass())) {
                        sql = this.handleListParameter(sql, (Collection)strictMap.get((Object)"list"));
                    }
                } else if (this.isMap(parameterObjectClass)) {
                    Map paramMap = (Map)parameterObject;
                    sql = this.handleMapParameter(sql, paramMap, parameterMappingList);
                } else {
                    sql = this.handleCommonParameter(sql, parameterMappingList, parameterObjectClass, parameterObject);
                }
            }
        }
        catch (Exception e) {
            return sqlWithoutReplacePlaceholder;
        }
        return sql;
    }

    private String beautifySql(String sql) {
        sql = sql.replaceAll("[\\s\n ]+", " ");
        return sql;
    }

    private String handleListParameter(String sql, Collection<?> col) {
        if (col != null && col.size() != 0) {
            for (Object obj : col) {
                String value = null;
                Class<String> objClass = obj.getClass();
                if (this.isPrimitiveOrPrimitiveWrapper(objClass)) {
                    value = obj.toString();
                } else if (objClass.isAssignableFrom(String.class)) {
                    value = "\"" + obj.toString() + "\"";
                }
                sql = sql.replaceFirst("\\?", value);
            }
        }
        return sql;
    }

    private String handleMapParameter(String sql, Map<?, ?> paramMap, List<ParameterMapping> parameterMappingList) {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyName = parameterMapping.getProperty();
            Object propertyValue = paramMap.get(propertyName);
            if (propertyValue == null) continue;
            if (propertyValue.getClass().isAssignableFrom(String.class)) {
                propertyValue = "\"" + propertyValue + "\"";
            }
            sql = sql.replaceFirst("\\?", propertyValue.toString());
        }
        return sql;
    }

    private String handleCommonParameter(String sql, List<ParameterMapping> parameterMappingList, Class<?> parameterObjectClass, Object parameterObject) throws Exception {
        for (ParameterMapping parameterMapping : parameterMappingList) {
            String propertyValue = null;
            if (this.isPrimitiveOrPrimitiveWrapper(parameterObjectClass)) {
                propertyValue = parameterObject.toString();
            } else {
                String propertyName = parameterMapping.getProperty();
                Field field = parameterObjectClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                propertyValue = String.valueOf(field.get(parameterObject));
                if (parameterMapping.getJavaType().isAssignableFrom(String.class)) {
                    propertyValue = "\"" + propertyValue + "\"";
                }
            }
            sql = sql.replaceFirst("\\?", propertyValue);
        }
        return sql;
    }

    private boolean isPrimitiveOrPrimitiveWrapper(Class<?> parameterObjectClass) {
        return parameterObjectClass.isPrimitive() || parameterObjectClass.isAssignableFrom(Byte.class) || parameterObjectClass.isAssignableFrom(Short.class) || parameterObjectClass.isAssignableFrom(Integer.class) || parameterObjectClass.isAssignableFrom(Long.class) || parameterObjectClass.isAssignableFrom(Double.class) || parameterObjectClass.isAssignableFrom(Float.class) || parameterObjectClass.isAssignableFrom(Character.class) || parameterObjectClass.isAssignableFrom(Boolean.class);
    }

    private boolean isStrictMap(Class<?> parameterObjectClass) {
        return parameterObjectClass.isAssignableFrom(DefaultSqlSession.StrictMap.class);
    }

    private boolean isList(Class<?> clazz) {
        Class<?>[] interfaceClasses;
        for (Class<List> clazz2 : interfaceClasses = clazz.getInterfaces()) {
            if (!clazz2.isAssignableFrom(List.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isMap(Class<?> parameterObjectClass) {
        Class<?>[] interfaceClasses;
        for (Class<Map> clazz : interfaceClasses = parameterObjectClass.getInterfaces()) {
            if (!clazz.isAssignableFrom(Map.class)) continue;
            return true;
        }
        return false;
    }

    private void writeSqlInfoToServiceContext(String sql, List<Object> parameterMappingList, IDWSQLOptions option) {
        boolean configOfServiceLogForOperate = false;
        Map operateLogMap = DWServiceContext.getContext().getOperateLog();
        if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogRecord") && ((Boolean)operateLogMap.get("isLogRecord")).booleanValue()) {
            configOfServiceLogForOperate = true;
        }
        if (configOfServiceLogForOperate) {
            boolean combinedConfigValueOfSqlLogForOperate = true;
            boolean collectSqlLogForOperate = false;
            boolean daoOptionValueOfOperateLogEnabled = true;
            if (MapUtils.isNotEmpty((Map)operateLogMap) && operateLogMap.containsKey("isLogSqlRecord")) {
                combinedConfigValueOfSqlLogForOperate = (Boolean)operateLogMap.get("isLogSqlRecord");
            }
            if (combinedConfigValueOfSqlLogForOperate) {
                collectSqlLogForOperate = option != null ? (daoOptionValueOfOperateLogEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)option.get(DWSQLOptionsBuilder.OPTION_LOG_OPERATION_ENABLED)), (boolean)true)) : true;
            }
            if (collectSqlLogForOperate) {
                HashMap<String, Object> currentSqlMap = new HashMap<String, Object>();
                currentSqlMap.put("statement", sql);
                currentSqlMap.put("parameters", parameterMappingList);
                HashMap<Integer, HashMap<Integer, HashMap<String, Object>>> logRecordSqlMap = (HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>)operateLogMap.get("sqlMap");
                if (MapUtils.isNotEmpty((Map)logRecordSqlMap)) {
                    logRecordSqlMap.put(logRecordSqlMap.size() + 1, currentSqlMap);
                } else {
                    logRecordSqlMap = new HashMap<Integer, HashMap<Integer, HashMap<String, Object>>>();
                    logRecordSqlMap.put(1, currentSqlMap);
                    operateLogMap.put("sqlMap", logRecordSqlMap);
                }
            }
            if (_LOGGER.isDebugEnabled()) {
                _LOGGER.debug((Object)String.format("collectSqlLogForOperate=%b (configOfServiceLogForOperate=%b, combinedConfigValueOfSqlLogForOperate=%b, daoOptionValueOfOperateLogEnabled=%s !)", collectSqlLogForOperate, configOfServiceLogForOperate, combinedConfigValueOfSqlLogForOperate, daoOptionValueOfOperateLogEnabled));
            }
        }
    }
}

