/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.utils;

import com.digiwin.app.dao.mybatis.DWMybatisIgnore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DWManagementFieldUtil {
    static ThreadLocal<Map<Object, Object>> managementFieldLocal = new ThreadLocal();

    public static boolean isIgnore(String tableName) {
        DWManagementFieldUtil.checkAndInit();
        return managementFieldLocal.get().containsKey((Object)DWMybatisIgnore.ALL) || DWMybatisIgnore.ALL == managementFieldLocal.get().get(tableName);
    }

    public static boolean isIgnore(String tableName, String filed) {
        DWManagementFieldUtil.checkAndInit();
        return DWManagementFieldUtil.isIgnore(tableName) || managementFieldLocal.get().get(tableName) instanceof Set && ((Set)managementFieldLocal.get().get(tableName)).contains(filed);
    }

    public static boolean bindIgnoreTable(String tableName) {
        DWManagementFieldUtil.checkAndInit();
        managementFieldLocal.get().put(tableName, (Object)DWMybatisIgnore.ALL);
        return true;
    }

    public static boolean unbindIgnoreTable(String tableName) {
        DWManagementFieldUtil.checkIgnoreAll();
        return null != managementFieldLocal.get().remove(tableName);
    }

    public static void clearIgnoreTables() {
        DWManagementFieldUtil.checkAndInit();
        managementFieldLocal.get().clear();
    }

    public static boolean ignoreAll() {
        DWManagementFieldUtil.clearIgnoreTables();
        managementFieldLocal.get().put((Object)DWMybatisIgnore.ALL, new HashSet());
        return true;
    }

    public static boolean bindIgnoreFileds(String tableName, String ... fileds) {
        DWManagementFieldUtil.checkIgnoreAll();
        if (managementFieldLocal.get().get(tableName) == DWMybatisIgnore.ALL) {
            throw new RuntimeException("already ignore all management fields in table :" + tableName);
        }
        managementFieldLocal.get().put(tableName, new HashSet<String>(Arrays.asList(fileds)));
        return true;
    }

    public static boolean unbindIgnoreFileds(String tableName, String ... fileds) {
        DWManagementFieldUtil.checkIgnoreAll();
        if (managementFieldLocal.get().get(tableName) == DWMybatisIgnore.ALL) {
            throw new RuntimeException("already ignore all management fields in table :" + tableName);
        }
        if (managementFieldLocal.get().get(tableName) instanceof Set) {
            for (String filed : fileds) {
                ((Set)managementFieldLocal.get().get(tableName)).remove(filed);
            }
            return true;
        }
        return false;
    }

    public static boolean unbindIgnoreTables(String ... tableNames) {
        DWManagementFieldUtil.checkIgnoreAll();
        for (String tableName : tableNames) {
            managementFieldLocal.get().remove(tableName);
        }
        return true;
    }

    public static boolean bindIgnoreTables(String ... tableNames) {
        DWManagementFieldUtil.checkIgnoreAll();
        for (String tableName : tableNames) {
            managementFieldLocal.get().put(tableName, (Object)DWMybatisIgnore.ALL);
        }
        return true;
    }

    private static void checkIgnoreAll() {
        DWManagementFieldUtil.checkAndInit();
        if (managementFieldLocal.get().containsKey((Object)DWMybatisIgnore.ALL)) {
            throw new RuntimeException("already ignore all management fields");
        }
    }

    private static void checkAndInit() {
        Map<Object, Object> ignoreTable = managementFieldLocal.get();
        if (ignoreTable == null) {
            ignoreTable = new HashMap<Object, Object>();
            managementFieldLocal.set(ignoreTable);
        }
    }
}

