/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer.handler;

import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerCallback;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerHandler;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerInterceptor;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerParam;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerResponse;
import com.dap.component.rocketmq.producer.DWRocketMQProducerMessage;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class DWRocketMQProducerBaseHandler
implements DWRocketMQProducerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWRocketMQProducerBaseHandler.class);
    private Producer producer;
    private List<DWRocketMQProducerInterceptor> interceptors;
    private DWRocketMQProducerCallback responseCallback;
    private Gson gson = DWGsonProvider.getGson();

    public <T> void sendMessage(String topic, String tag, Boolean enableAsync, DWRocketMQProducerParam<T> requestParam) {
        Message dwMessage = this.buildDWRocketMessage(topic, tag, requestParam);
        dwMessage = this.invokeBefore(topic, dwMessage);
        this.doSend(enableAsync, topic, dwMessage);
    }

    protected void doSend(Boolean enableAsync, String topic, Message dwMessage) {
        if (enableAsync.booleanValue()) {
            this.sendAsync(topic, dwMessage);
        } else {
            this.sendSync(topic, dwMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSync(String topic, Message dwMessage) {
        SendReceipt sendReceipt = null;
        Exception exception = null;
        try {
            Message message = this.convertMessage(dwMessage);
            sendReceipt = this.producer.send(message);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            try {
                this.invokeAfter(topic, dwMessage, exception);
            }
            catch (Exception e) {
                LOGGER.error("Execute producer 'invokeAfter' failed after sync sending:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        DWRocketMQProducerResponse response = this.populateProducerResponse(sendReceipt, dwMessage);
        this.doResponseCallback(response, exception);
    }

    protected void sendAsync(String topic, Message dwMessage) {
        Message message = this.convertMessage(dwMessage);
        CompletableFuture resultFuture = this.producer.sendAsync(message);
        resultFuture.whenComplete((sendReceipt, throwable) -> {
            try {
                this.invokeAfter(topic, dwMessage, (Throwable)throwable);
            }
            catch (Exception e) {
                LOGGER.error("Execute producer 'invokeAfter' failed after async sending:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            DWRocketMQProducerResponse response = this.populateProducerResponse((SendReceipt)sendReceipt, dwMessage);
            this.doResponseCallback(response, (Throwable)throwable);
        });
    }

    protected <T> Message buildDWRocketMessage(String topic, String tag, DWRocketMQProducerParam<T> requestParam) {
        return new DWRocketMQProducerMessage(topic, this.parseJson(requestParam.getMsgBody()), tag, List.of(requestParam.getBusinessId()), null, null, new HashMap<String, String>());
    }

    protected Message convertMessage(Message dwMessage) {
        MessageBuilder builder = ClientServiceProvider.loadService().newMessageBuilder().setTopic(dwMessage.getTopic()).setBody(dwMessage.getBody().array());
        if (dwMessage.getTag().isPresent() && StringUtils.hasText((String)((String)dwMessage.getTag().get()))) {
            builder.setTag((String)dwMessage.getTag().get());
        }
        if (!CollectionUtils.isEmpty((Collection)dwMessage.getKeys())) {
            builder.setKeys((String[])dwMessage.getKeys().toArray(String[]::new));
        }
        if (dwMessage.getDeliveryTimestamp().isPresent()) {
            builder.setDeliveryTimestamp(((Long)dwMessage.getDeliveryTimestamp().get()).longValue());
        }
        if (dwMessage.getMessageGroup().isPresent() && StringUtils.hasText((String)((String)dwMessage.getMessageGroup().get()))) {
            builder.setMessageGroup((String)dwMessage.getMessageGroup().get());
        }
        if (!CollectionUtils.isEmpty((Map)dwMessage.getProperties())) {
            dwMessage.getProperties().forEach((arg_0, arg_1) -> ((MessageBuilder)builder).addProperty(arg_0, arg_1));
        }
        return builder.build();
    }

    protected byte[] parseJson(Object msgBody) {
        return this.gson.toJson(msgBody).getBytes(StandardCharsets.UTF_8);
    }

    protected DWRocketMQProducerResponse populateProducerResponse(SendReceipt sendReceipt, Message dwMessage) {
        DWRocketMQProducerResponse response = new DWRocketMQProducerResponse(Boolean.valueOf(false));
        if (Objects.nonNull(sendReceipt) && Objects.nonNull(sendReceipt.getMessageId())) {
            response.setSuccess(Boolean.valueOf(true));
            response.setMessageId(sendReceipt.getMessageId().toString());
        }
        if (Objects.nonNull(dwMessage)) {
            response.setExtInfo(this.extractMsgExt(dwMessage));
        }
        return response;
    }

    protected void doResponseCallback(DWRocketMQProducerResponse response, Throwable exception) {
        if (Objects.nonNull(exception)) {
            LOGGER.warn("Send message to rocketmq error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
        if (Objects.nonNull(this.responseCallback)) {
            if (!response.getSuccess().booleanValue()) {
                if (Objects.isNull(exception)) {
                    exception = new DWRocketMQException("Response 'messageId' is null when send message to rocketmq.");
                }
                this.responseCallback.onFailure(response, exception);
            } else {
                this.responseCallback.onSuccess(response);
            }
        }
    }

    protected void invokeAfter(String topic, Message msg, Throwable ex) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (DWRocketMQProducerInterceptor interceptor : this.interceptors) {
                if (!CollectionUtils.isEmpty((Collection)interceptor.matchTopics()) && !interceptor.matchTopics().contains(topic)) continue;
                interceptor.after(msg, ex);
            }
        }
    }

    public Producer getProducer() {
        return this.producer;
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    public void setInterceptors(List<DWRocketMQProducerInterceptor> interceptors) {
        this.interceptors = interceptors;
        this.interceptors.sort(Comparator.comparingInt(DWRocketMQProducerInterceptor::getOrder));
    }

    public void setResponseCallback(DWRocketMQProducerCallback responseCallback) {
        this.responseCallback = responseCallback;
    }

    private Message invokeBefore(String topic, Message msg) {
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            for (DWRocketMQProducerInterceptor interceptor : this.interceptors) {
                if (!CollectionUtils.isEmpty((Collection)interceptor.matchTopics()) && !interceptor.matchTopics().contains(topic)) continue;
                msg = interceptor.before(msg);
            }
        }
        return msg;
    }

    private String extractMsgExt(Message message) {
        if (Objects.nonNull(message)) {
            String result;
            StringBuilder sb = new StringBuilder("msgExt{");
            if (StringUtils.hasText((String)message.getTopic())) {
                sb.append("topic=").append(message.getTopic()).append(",");
            }
            if (message.getTag().isPresent()) {
                sb.append("tag=").append((String)message.getTag().get()).append(",");
            }
            if (!CollectionUtils.isEmpty((Collection)message.getKeys())) {
                sb.append("keys=").append(message.getKeys()).append(",");
            }
            if (message.getMessageGroup().isPresent()) {
                sb.append("messageGroup=").append((String)message.getMessageGroup().get()).append(",");
            }
            if (message.getDeliveryTimestamp().isPresent()) {
                sb.append("deliveryTimestamp=").append(message.getDeliveryTimestamp().get()).append(",");
            }
            if ((result = sb.toString()).lastIndexOf(",") != -1) {
                result = result.substring(0, result.lastIndexOf(","));
            }
            return result + "}";
        }
        return null;
    }
}

