/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer;

import com.dap.component.rocketmq.api.properties.DWRocketMQProducerProperties;
import com.dap.component.rocketmq.producer.DWRocketMQProducerClassPathBeanDefinitionScanner;
import com.dap.component.rocketmq.producer.DWRocketMQProducerHolder;
import com.dap.component.rocketmq.producer.annotation.DWRocketMQProducer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWRocketMQProducerBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private DWRocketMQProducerHolder producerHolder = new DWRocketMQProducerHolder();
    private String scanBasePackage;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DWRocketMQProducerClassPathBeanDefinitionScanner scanner = new DWRocketMQProducerClassPathBeanDefinitionScanner(registry, this.applicationContext, this.producerHolder);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DWRocketMQProducer.class));
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.getProducerPackageName(registry), (String)",; \t\n"));
    }

    private String getProducerPackageName(BeanDefinitionRegistry registry) {
        DWRocketMQProducerProperties producerProperties;
        String basePackage = "com.digiwin";
        Set<String> packages = null;
        if (!StringUtils.hasText((String)this.scanBasePackage) && StringUtils.hasText((String)(producerProperties = (DWRocketMQProducerProperties)this.applicationContext.getBean("dw-rocketMQProducerProperties", DWRocketMQProducerProperties.class)).getScanBasePackage())) {
            this.scanBasePackage = producerProperties.getScanBasePackage();
        }
        if (StringUtils.hasText((String)this.scanBasePackage)) {
            basePackage = this.scanBasePackage;
        } else {
            packages = this.extractAnnotationScanPackages(registry);
            if (!CollectionUtils.isEmpty(packages)) {
                basePackage = String.join((CharSequence)",", packages);
            }
        }
        return basePackage;
    }

    private Set<String> extractAnnotationScanPackages(BeanDefinitionRegistry registry) {
        HashSet<String> packages = new HashSet<String>();
        for (String beanName : registry.getBeanDefinitionNames()) {
            Class[] basePackageClasses;
            Map attrs;
            AnnotationMetadata metadata;
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!(bd instanceof AnnotatedBeanDefinition) || !(metadata = ((AnnotatedBeanDefinition)bd).getMetadata()).hasAnnotation(ComponentScan.class.getName()) || CollectionUtils.isEmpty((Map)(attrs = metadata.getAnnotationAttributes(ComponentScan.class.getName())))) continue;
            Collections.addAll(packages, (String[])attrs.get("basePackages"));
            for (Class clazz : basePackageClasses = (Class[])attrs.get("basePackageClasses")) {
                packages.add(clazz.getPackage().getName());
            }
        }
        return packages;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setScanBasePackage(String scanBasePackage) {
        this.scanBasePackage = scanBasePackage;
    }

    public void destroy() throws Exception {
        if (Objects.nonNull(this.producerHolder)) {
            this.producerHolder.closeAll();
        }
    }
}

