/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer;

import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerCallback;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerHandler;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerInterceptor;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerParam;
import com.dap.component.rocketmq.api.properties.DWRocketMQProducerProperties;
import com.dap.component.rocketmq.enums.MessageType;
import com.dap.component.rocketmq.producer.DWRocketMQProducerHolder;
import com.dap.component.rocketmq.producer.DWRocketMQProducerTransactionChecker;
import com.dap.component.rocketmq.producer.annotation.DWRocketMQPusher;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerBaseHandler;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerDelayHandler;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerNormalHandler;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerOrderlyHandler;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerTransactionHandler;
import com.dap.component.rocketmq.producer.params.DWRocketMQProducerTransactionParam;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;
import org.apache.rocketmq.client.apis.StaticSessionCredentialsProvider;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.apis.producer.ProducerBuilder;
import org.apache.rocketmq.client.apis.producer.TransactionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DWRocketMQProducerProxy
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWRocketMQProducerProxy.class);
    private ApplicationContext applicationContext;
    private Class<?> targetClazz;
    private DWRocketMQProducerHolder producerHolder;
    private List<DWRocketMQProducerInterceptor> interceptors;
    private DWRocketMQProducerProperties producerProperties;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DWRocketMQProducerProxy that = (DWRocketMQProducerProxy)o;
        return Objects.equals(this.targetClazz, that.targetClazz);
    }

    public int hashCode() {
        return Objects.hashCode(this.targetClazz);
    }

    public DWRocketMQProducerProxy(ApplicationContext applicationContext, Class<?> targetClazz, DWRocketMQProducerHolder producerHolder) {
        this.applicationContext = applicationContext;
        this.producerHolder = producerHolder;
        this.targetClazz = targetClazz;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        DWRocketMQPusher pusherAnnotation = (DWRocketMQPusher)AnnotationUtils.getAnnotation((Method)method, DWRocketMQPusher.class);
        if (!Objects.isNull(pusherAnnotation)) {
            String topicName = pusherAnnotation.topicName();
            if (!StringUtils.hasText((String)topicName)) {
                throw new DWRocketMQException(String.format("'%s' is empty when invoking '%s.%s()'", "topicName", obj.getClass().getName(), method.getName()));
            }
            MessageType msgType = pusherAnnotation.msgType();
            if (Objects.isNull((Object)msgType)) {
                throw new DWRocketMQException(String.format("'%s' is empty when invoking '%s.%s()'", "msgType", obj.getClass().getName(), method.getName()));
            }
            ArgsEntity argsEntity = this.getArgsEntity(args);
            if (Objects.isNull(argsEntity.param) || Objects.isNull(argsEntity.param.getMsgBody())) {
                throw new DWRocketMQException(String.format("'%s' is empty when invoking '%s.%s()'", "producer param or data", obj.getClass().getName(), method.getName()));
            }
            String producerName = this.makeProducerName(msgType, obj.getClass().getName(), method.getName());
            DWRocketMQProducerTransactionChecker txCheck = this.checkAndGetTransactionChecker(msgType, argsEntity);
            Producer producer = null;
            try {
                producer = this.makeAndGetProducer(producerName, this.getProducerProperties(), topicName, txCheck);
            }
            catch (Exception e) {
                throw new DWRocketMQException("Create producer instance failed", e);
            }
            this.sendMessage(producer, argsEntity, topicName, pusherAnnotation.tagExpress(), msgType, pusherAnnotation.enableAsync());
            return null;
        }
        return proxy.invokeSuper(obj, args);
    }

    private void sendMessage(Producer producer, ArgsEntity argsParam, String topicName, String msgTag, MessageType msgType, boolean enableAsync) {
        DWRocketMQProducerHandler producerHandler = this.getProducerHandler(msgType, producer, argsParam.callback);
        producerHandler.sendMessage(topicName, msgTag, Boolean.valueOf(enableAsync), argsParam.param);
    }

    private Producer buildProducer(DWRocketMQProducerProperties producerProperties, String topic, TransactionChecker txChecker) throws ClientException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        ClientConfiguration clientConfiguration = ClientConfiguration.newBuilder().setEndpoints(producerProperties.getEndpoints()).setCredentialProvider((SessionCredentialsProvider)new StaticSessionCredentialsProvider(producerProperties.getAccessKey(), producerProperties.getSecretKey())).enableSsl(producerProperties.getSslEnabled().booleanValue()).setRequestTimeout(Duration.ofMillis(producerProperties.getSendMsgTimeout().intValue())).build();
        ProducerBuilder builder = provider.newProducerBuilder().setClientConfiguration(clientConfiguration).setTopics(new String[]{topic}).setMaxAttempts(producerProperties.getRetrySendTimes().intValue());
        if (!Objects.isNull(txChecker)) {
            builder.setTransactionChecker(txChecker);
        }
        return builder.build();
    }

    private String makeProducerName(MessageType msgType, String producerClazz, String txMethod) {
        if (msgType == MessageType.TRANSACTION) {
            return String.format("producer.tx.%s.%s", producerClazz, txMethod);
        }
        return "producer.public";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Producer makeAndGetProducer(String producerName, DWRocketMQProducerProperties producerProperties, String topic, TransactionChecker transactionChecker) throws ClientException {
        Producer producer = null;
        producer = this.producerHolder.getProducer(producerName);
        if (!Objects.isNull(producer)) return producer;
        Class<DWRocketMQProducerProxy> clazz = DWRocketMQProducerProxy.class;
        synchronized (DWRocketMQProducerProxy.class) {
            producer = this.producerHolder.getProducer(producerName);
            if (!Objects.isNull(producer)) return producer;
            producer = this.buildProducer(producerProperties, topic, transactionChecker);
            this.producerHolder.putProducer(producerName, producer);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return producer;
        }
    }

    private DWRocketMQProducerTransactionChecker checkAndGetTransactionChecker(MessageType messageType, ArgsEntity argsParam) {
        DWRocketMQProducerTransactionChecker transactionChecker = null;
        if (messageType == MessageType.TRANSACTION) {
            if (!DWRocketMQProducerTransactionParam.class.isAssignableFrom(argsParam.param.getClass())) {
                throw new DWRocketMQException("'requestParam' must be instance of DWRocketMQProducerTransactionParam when 'messageType' is Transaction");
            }
            DWRocketMQProducerTransactionParam transactionParam = (DWRocketMQProducerTransactionParam)argsParam.param;
            if (Objects.isNull(transactionParam.getTransactionChecker())) {
                throw new DWRocketMQException("'transactionChecker' must not be empty");
            }
            transactionChecker = transactionParam.getTransactionChecker();
            transactionChecker.setResponseCallback(argsParam.callback);
        }
        return transactionChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DWRocketMQProducerInterceptor> getProducerInterceptors() {
        if (CollectionUtils.isEmpty(this.interceptors)) {
            DWRocketMQProducerProxy dWRocketMQProducerProxy = this;
            synchronized (dWRocketMQProducerProxy) {
                Map beanMap;
                if (CollectionUtils.isEmpty(this.interceptors) && !CollectionUtils.isEmpty((Map)(beanMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, DWRocketMQProducerInterceptor.class)))) {
                    this.interceptors = new ArrayList(beanMap.values());
                }
            }
        }
        return this.interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DWRocketMQProducerProperties getProducerProperties() {
        if (!Objects.isNull(this.producerProperties)) return this.producerProperties;
        Class<DWRocketMQProducerProperties> clazz = DWRocketMQProducerProperties.class;
        synchronized (DWRocketMQProducerProperties.class) {
            if (!Objects.isNull(this.producerProperties)) return this.producerProperties;
            this.producerProperties = (DWRocketMQProducerProperties)this.applicationContext.getBean("dw-rocketMQProducerProperties", DWRocketMQProducerProperties.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.producerProperties;
        }
    }

    private DWRocketMQProducerHandler getProducerHandler(MessageType msgType, Producer producer, DWRocketMQProducerCallback responseCallback) {
        DWRocketMQProducerBaseHandler producerHandler = null;
        switch (msgType) {
            case DELAY: {
                producerHandler = new DWRocketMQProducerDelayHandler();
                break;
            }
            case ORDERLY: {
                producerHandler = new DWRocketMQProducerOrderlyHandler();
                break;
            }
            case TRANSACTION: {
                producerHandler = new DWRocketMQProducerTransactionHandler();
                break;
            }
            default: {
                producerHandler = new DWRocketMQProducerNormalHandler();
            }
        }
        producerHandler.setProducer(producer);
        producerHandler.setInterceptors(this.getProducerInterceptors());
        producerHandler.setResponseCallback(responseCallback);
        return producerHandler;
    }

    private ArgsEntity getArgsEntity(Object[] args) {
        DWRocketMQProducerParam param = null;
        DWRocketMQProducerCallback callback = null;
        for (Object arg : args) {
            if (DWRocketMQProducerParam.class.isAssignableFrom(arg.getClass())) {
                param = (DWRocketMQProducerParam)arg;
                continue;
            }
            if (!DWRocketMQProducerCallback.class.isAssignableFrom(arg.getClass())) continue;
            callback = (DWRocketMQProducerCallback)arg;
        }
        return new ArgsEntity(param, callback);
    }

    static class ArgsEntity {
        DWRocketMQProducerParam param;
        DWRocketMQProducerCallback callback;

        public ArgsEntity(DWRocketMQProducerParam param, DWRocketMQProducerCallback callback) {
            this.param = param;
            this.callback = callback;
        }
    }
}

