/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.consumer;

import com.dap.component.rocketmq.api.properties.DWRocketMQConsumerProperties;
import com.dap.component.rocketmq.consumer.DWRocketMQConsumeListenerProcessor;
import com.dap.component.rocketmq.consumer.DWRocketMQConsumerHolder;
import com.dap.component.rocketmq.consumer.annotation.DWRocketMQConsumeListener;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;

public class DWRocketMQConsumerBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWRocketMQConsumerBeanPostProcessor.class);
    private final DWRocketMQConsumerHolder consumerHolder = new DWRocketMQConsumerHolder();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Map<Method, DWRocketMQConsumeListener> methodMap = this.scanConsumeListenerAnnotation(targetClass);
            if (CollectionUtils.isEmpty(methodMap)) {
                this.nonAnnotatedClasses.add(targetClass);
            } else {
                DWRocketMQConsumerProperties consumerProperties = (DWRocketMQConsumerProperties)this.applicationContext.getBean("dw-rocketMQConsumerProperties", DWRocketMQConsumerProperties.class);
                methodMap.forEach((method, dwRocketMQConsumeListener) -> new DWRocketMQConsumeListenerProcessor(this.applicationContext, this.consumerHolder, consumerProperties).processConsumeListener((DWRocketMQConsumeListener)dwRocketMQConsumeListener, (Method)method, bean));
            }
        }
        return bean;
    }

    private Map<Method, DWRocketMQConsumeListener> scanConsumeListenerAnnotation(Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> (DWRocketMQConsumeListener)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, DWRocketMQConsumeListener.class));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        this.consumerHolder.closeAll();
    }
}

